/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.discovery;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.discovery.impl.AggregateDiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryProvider;

class AggregateDiscoveryProviderService
implements Service {
    private final Consumer<DiscoveryProvider> provider;
    private final List<Supplier<DiscoveryProvider>> providers;

    AggregateDiscoveryProviderService(Consumer<DiscoveryProvider> provider, List<Supplier<DiscoveryProvider>> providers) {
        this.provider = provider;
        this.providers = providers;
    }

    public void start(StartContext context) throws StartException {
        DiscoveryProvider[] providers = new DiscoveryProvider[this.providers.size()];
        for (int i = 0; i < providers.length; ++i) {
            providers[i] = this.providers.get(i).get();
        }
        this.provider.accept((DiscoveryProvider)new AggregateDiscoveryProvider(providers));
    }

    public void stop(StopContext context) {
        this.provider.accept(null);
    }
}

