/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp.validation;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.grammars.XMLSchemaDescription;

final class SoftReferenceGrammarPool
implements XMLGrammarPool {
    protected static final int TABLE_SIZE = 11;
    protected static final Grammar[] ZERO_LENGTH_GRAMMAR_ARRAY = new Grammar[0];
    protected Entry[] fGrammars = null;
    protected boolean fPoolIsLocked;
    protected int fGrammarCount = 0;
    protected final ReferenceQueue fReferenceQueue = new ReferenceQueue();

    public SoftReferenceGrammarPool() {
        this.fGrammars = new Entry[11];
        this.fPoolIsLocked = false;
    }

    public SoftReferenceGrammarPool(int initialCapacity) {
        this.fGrammars = new Entry[initialCapacity];
        this.fPoolIsLocked = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Grammar[] retrieveInitialGrammarSet(String grammarType) {
        Entry[] entryArray = this.fGrammars;
        synchronized (this.fGrammars) {
            this.clean();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ZERO_LENGTH_GRAMMAR_ARRAY;
        }
    }

    public void cacheGrammars(String grammarType, Grammar[] grammars) {
        if (!this.fPoolIsLocked) {
            for (int i = 0; i < grammars.length; ++i) {
                this.putGrammar(grammars[i]);
            }
        }
    }

    public Grammar retrieveGrammar(XMLGrammarDescription desc) {
        return this.getGrammar(desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void putGrammar(Grammar grammar) {
        if (this.fPoolIsLocked) return;
        Entry[] entryArray = this.fGrammars;
        synchronized (this.fGrammars) {
            this.clean();
            XMLGrammarDescription desc = grammar.getGrammarDescription();
            int hash = this.hashCode(desc);
            int index = (hash & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry = this.fGrammars[index];
            while (entry != null) {
                if (entry.hash == hash && this.equals(entry.desc, desc)) {
                    if (entry.grammar.get() == grammar) return;
                    entry.grammar = new SoftGrammarReference(entry, grammar, this.fReferenceQueue);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                entry = entry.next;
            }
            this.fGrammars[index] = entry = new Entry(hash, index, desc, grammar, this.fGrammars[index], this.fReferenceQueue);
            ++this.fGrammarCount;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Grammar getGrammar(XMLGrammarDescription desc) {
        Entry[] entryArray = this.fGrammars;
        synchronized (this.fGrammars) {
            this.clean();
            int hash = this.hashCode(desc);
            int index = (hash & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry = this.fGrammars[index];
            while (entry != null) {
                Grammar tempGrammar = (Grammar)entry.grammar.get();
                if (tempGrammar == null) {
                    this.removeEntry(entry);
                } else if (entry.hash == hash && this.equals(entry.desc, desc)) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return tempGrammar;
                }
                entry = entry.next;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Grammar removeGrammar(XMLGrammarDescription desc) {
        Entry[] entryArray = this.fGrammars;
        synchronized (this.fGrammars) {
            this.clean();
            int hash = this.hashCode(desc);
            int index = (hash & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry = this.fGrammars[index];
            while (entry != null) {
                if (entry.hash == hash && this.equals(entry.desc, desc)) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return this.removeEntry(entry);
                }
                entry = entry.next;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsGrammar(XMLGrammarDescription desc) {
        Entry[] entryArray = this.fGrammars;
        synchronized (this.fGrammars) {
            this.clean();
            int hash = this.hashCode(desc);
            int index = (hash & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry = this.fGrammars[index];
            while (entry != null) {
                Grammar tempGrammar = (Grammar)entry.grammar.get();
                if (tempGrammar == null) {
                    this.removeEntry(entry);
                } else if (entry.hash == hash && this.equals(entry.desc, desc)) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
                entry = entry.next;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    public void lockPool() {
        this.fPoolIsLocked = true;
    }

    public void unlockPool() {
        this.fPoolIsLocked = false;
    }

    public void clear() {
        for (int i = 0; i < this.fGrammars.length; ++i) {
            if (this.fGrammars[i] == null) continue;
            this.fGrammars[i].clear();
            this.fGrammars[i] = null;
        }
        this.fGrammarCount = 0;
    }

    public boolean equals(XMLGrammarDescription desc1, XMLGrammarDescription desc2) {
        if (desc1 instanceof XMLSchemaDescription) {
            if (!(desc2 instanceof XMLSchemaDescription)) {
                return false;
            }
            XMLSchemaDescription sd1 = (XMLSchemaDescription)desc1;
            XMLSchemaDescription sd2 = (XMLSchemaDescription)desc2;
            String targetNamespace = sd1.getTargetNamespace();
            if (targetNamespace != null ? !targetNamespace.equals(sd2.getTargetNamespace()) : sd2.getTargetNamespace() != null) {
                return false;
            }
            String expandedSystemId = sd1.getExpandedSystemId();
            return !(expandedSystemId != null ? !expandedSystemId.equals(sd2.getExpandedSystemId()) : sd2.getExpandedSystemId() != null);
        }
        return desc1.equals(desc2);
    }

    public int hashCode(XMLGrammarDescription desc) {
        if (desc instanceof XMLSchemaDescription) {
            XMLSchemaDescription sd = (XMLSchemaDescription)desc;
            String targetNamespace = sd.getTargetNamespace();
            String expandedSystemId = sd.getExpandedSystemId();
            int hash = targetNamespace != null ? targetNamespace.hashCode() : 0;
            return hash ^= expandedSystemId != null ? expandedSystemId.hashCode() : 0;
        }
        return desc.hashCode();
    }

    private Grammar removeEntry(Entry entry) {
        if (entry.prev != null) {
            entry.prev.next = entry.next;
        } else {
            this.fGrammars[entry.bucket] = entry.next;
        }
        if (entry.next != null) {
            entry.next.prev = entry.prev;
        }
        --this.fGrammarCount;
        entry.grammar.entry = null;
        return (Grammar)entry.grammar.get();
    }

    private void clean() {
        Reference ref = this.fReferenceQueue.poll();
        while (ref != null) {
            Entry entry = ((SoftGrammarReference)ref).entry;
            if (entry != null) {
                this.removeEntry(entry);
            }
            ref = this.fReferenceQueue.poll();
        }
    }

    static final class SoftGrammarReference
    extends SoftReference {
        public Entry entry;

        protected SoftGrammarReference(Entry entry, Grammar grammar, ReferenceQueue queue) {
            super(grammar, queue);
            this.entry = entry;
        }
    }

    static final class Entry {
        public int hash;
        public int bucket;
        public Entry prev;
        public Entry next;
        public XMLGrammarDescription desc;
        public SoftGrammarReference grammar;

        protected Entry(int hash, int bucket, XMLGrammarDescription desc, Grammar grammar, Entry next, ReferenceQueue queue) {
            this.hash = hash;
            this.bucket = bucket;
            this.prev = null;
            this.next = next;
            if (next != null) {
                next.prev = this;
            }
            this.desc = desc;
            this.grammar = new SoftGrammarReference(this, grammar, queue);
        }

        protected void clear() {
            this.desc = null;
            this.grammar = null;
            if (this.next != null) {
                this.next.clear();
                this.next = null;
            }
        }
    }
}

