/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.dto;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;

@XmlRootElement(name="connector")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JMXConnectorDTO {
    @XmlAttribute(name="connector-host")
    String connectorHost;
    @XmlAttribute(name="connector-port", required=true)
    Integer connectorPort;
    @XmlAttribute(name="rmi-registry-port")
    Integer rmiRegistryPort;
    @XmlAttribute(name="jmx-realm")
    String jmxRealm;
    @XmlAttribute(name="object-name")
    String objectName;
    @XmlAttribute(name="authenticator-type")
    String authenticatorType;
    @XmlAttribute(name="secured")
    Boolean secured;
    @XmlAttribute(name="key-store-provider")
    String keyStoreProvider;
    @XmlAttribute(name="key-store-type")
    String keyStoreType;
    @XmlAttribute(name="key-store-path")
    String keyStorePath;
    @XmlAttribute(name="key-store-password")
    String keyStorePassword;
    @XmlAttribute(name="trust-store-provider")
    String trustStoreProvider;
    @XmlAttribute(name="trust-store-type")
    String trustStoreType;
    @XmlAttribute(name="trust-store-path")
    String trustStorePath;
    @XmlAttribute(name="trust-store-password")
    String trustStorePassword;
    @XmlAttribute(name="password-codec")
    String passwordCodec;

    public String getConnectorHost() {
        return this.connectorHost;
    }

    public int getConnectorPort() {
        return this.connectorPort;
    }

    public Integer getRmiRegistryPort() {
        return this.rmiRegistryPort;
    }

    public String getJmxRealm() {
        return this.jmxRealm;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getAuthenticatorType() {
        return this.authenticatorType;
    }

    public Boolean isSecured() {
        return this.secured;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public String getKeyStorePassword() throws Exception {
        return this.getPassword(this.keyStorePassword);
    }

    public String getTrustStoreProvider() {
        return this.trustStoreProvider;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public String getTrustStorePassword() throws Exception {
        return this.getPassword(this.trustStorePassword);
    }

    private String getPassword(String password) throws Exception {
        return PasswordMaskingUtil.resolveMask((String)password, (String)this.passwordCodec);
    }
}

