/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform.description;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.description.ChainedPlaceholderResolver;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformingDescription;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilderImpl;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;

class ChainedTransformationDescriptionBuilderImpl
implements ChainedTransformationDescriptionBuilder {
    private final ModelVersion currentVersion;
    private final Map<ModelVersionPair, TransformationDescriptionBuilder> builders = new HashMap<ModelVersionPair, TransformationDescriptionBuilder>();
    private final PathElement element;

    ChainedTransformationDescriptionBuilderImpl(ModelVersion currentVersion, PathElement element) {
        this.currentVersion = currentVersion;
        this.element = element;
    }

    @Override
    public ResourceTransformationDescriptionBuilder createBuilder(ModelVersion fromVersion, ModelVersion toVersion) {
        ResourceTransformationDescriptionBuilderImpl builder = new ResourceTransformationDescriptionBuilderImpl(this.element);
        this.builders.put(new ModelVersionPair(fromVersion, toVersion), builder);
        return builder;
    }

    @Override
    public Map<ModelVersion, TransformationDescription> build(ModelVersion ... versions) {
        ModelVersion[] allVersions = new ModelVersion[versions.length + 1];
        allVersions[0] = this.currentVersion;
        System.arraycopy(versions, 0, allVersions, 1, versions.length);
        Arrays.sort(allVersions, new Comparator<ModelVersion>(){

            @Override
            public int compare(ModelVersion o1, ModelVersion o2) {
                return ModelVersion.compare(o1, o2);
            }
        });
        return this.doBuild(allVersions);
    }

    @Override
    public void buildAndRegister(SubsystemRegistration registration, ModelVersion[] ... chains) {
        for (ModelVersion[] chain : chains) {
            for (Map.Entry<ModelVersion, TransformationDescription> entry : this.build(chain).entrySet()) {
                TransformationDescription.Tools.register(entry.getValue(), registration, (ModelVersionRange)entry.getKey());
            }
        }
    }

    @Override
    public void buildAndRegister(SubsystemTransformerRegistration registration, ModelVersion[] ... chains) {
        for (ModelVersion[] chain : chains) {
            for (Map.Entry<ModelVersion, TransformationDescription> entry : this.build(chain).entrySet()) {
                TransformationDescription.Tools.register(entry.getValue(), registration, (ModelVersionRange)entry.getKey());
            }
        }
    }

    private Map<ModelVersion, TransformationDescription> doBuild(ModelVersion ... versions) {
        HashMap<ModelVersion, TransformationDescription> result = new HashMap<ModelVersion, TransformationDescription>();
        LinkedHashMap<ModelVersionPair, ChainedPlaceholderResolver> placeholderResolvers = new LinkedHashMap<ModelVersionPair, ChainedPlaceholderResolver>();
        for (int i = 1; i < versions.length; ++i) {
            ModelVersionPair pair = new ModelVersionPair(versions[i - 1], versions[i]);
            TransformationDescriptionBuilder builder = this.builders.get(pair);
            if (builder == null) {
                builder = new ResourceTransformationDescriptionBuilderImpl(this.element);
            }
            placeholderResolvers.put(pair, ChainedPlaceholderResolver.create(builder.build()));
            ChainedTransformingDescription desc = new ChainedTransformingDescription(this.element, new LinkedHashMap<ModelVersionPair, ChainedPlaceholderResolver>(placeholderResolvers));
            result.put(pair.toVersion, desc);
        }
        return result;
    }

    static class ModelVersionPair {
        private final ModelVersion fromVersion;
        private final ModelVersion toVersion;

        public ModelVersionPair(ModelVersion fromVersion, ModelVersion toVersion) {
            this.fromVersion = fromVersion;
            this.toVersion = toVersion;
        }

        public int hashCode() {
            int result = this.fromVersion.hashCode();
            return 31 * result + this.toVersion.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ModelVersionPair)) {
                return false;
            }
            ModelVersionPair other = (ModelVersionPair)obj;
            return other.fromVersion.equals((Object)this.fromVersion) && other.toVersion.equals((Object)this.toVersion);
        }

        public String toString() {
            return "ModelVersionPair [fromVersion=" + this.fromVersion + ", toVersion=" + this.toVersion + "]";
        }
    }
}

