/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem.deployment;

import java.util.List;
import javax.ejb.ConcurrencyManagementType;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ejb3.component.singleton.SingletonComponent;
import org.jboss.as.ejb3.component.singleton.SingletonComponentDescription;
import org.jboss.as.ejb3.subsystem.deployment.AbstractEJBComponentRuntimeHandler;
import org.jboss.as.ejb3.subsystem.deployment.EJBComponentType;
import org.jboss.as.ejb3.subsystem.deployment.SingletonBeanDeploymentResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

public class SingletonBeanRuntimeHandler
extends AbstractEJBComponentRuntimeHandler<SingletonComponent> {
    public static final SingletonBeanRuntimeHandler INSTANCE = new SingletonBeanRuntimeHandler();

    private SingletonBeanRuntimeHandler() {
        super(EJBComponentType.SINGLETON, SingletonComponent.class);
    }

    @Override
    protected void executeReadAttribute(String attributeName, OperationContext context, SingletonComponent component, PathAddress address) {
        SingletonComponentDescription componentDescription = (SingletonComponentDescription)component.getComponentDescription();
        ModelNode result = context.getResult();
        if (SingletonBeanDeploymentResourceDefinition.INIT_ON_STARTUP.getName().equals(attributeName)) {
            result.set(componentDescription.isInitOnStartup());
        } else if (SingletonBeanDeploymentResourceDefinition.CONCURRENCY_MANAGEMENT_TYPE.getName().equals(attributeName)) {
            ConcurrencyManagementType concurrencyManagementType = componentDescription.getConcurrencyManagementType();
            if (concurrencyManagementType != null) {
                result.set(concurrencyManagementType.toString());
            }
        } else if (SingletonBeanDeploymentResourceDefinition.DEPENDS_ON.getName().equals(attributeName)) {
            List<ServiceName> dependsOn = componentDescription.getDependsOn();
            for (ServiceName dep : dependsOn) {
                String[] nameArray = dep.toArray();
                result.add(nameArray[nameArray.length - 2]);
            }
        } else {
            super.executeReadAttribute(attributeName, context, component, address);
        }
    }
}

