/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.security;

import java.security.Policy;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.security.SecurityActions;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.Assert;
import org.wildfly.security.manager.WildFlySecurityManager;

public abstract class JaccService<T>
implements Service<PolicyConfiguration> {
    private static final String JACC_MODULE = "org.jboss.as.security.jacc-module";
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"jacc"});
    private final String contextId;
    private final T metaData;
    private final Boolean standalone;
    private volatile PolicyConfiguration policyConfiguration;
    private final InjectedValue<PolicyConfiguration> parentPolicy = new InjectedValue();

    public JaccService(String contextId, T metaData, Boolean standalone) {
        Assert.checkNotNullParam((String)contextId, (Object)contextId);
        this.contextId = contextId;
        this.metaData = metaData;
        this.standalone = standalone;
    }

    public PolicyConfiguration getValue() throws IllegalStateException, IllegalArgumentException {
        return this.policyConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        try {
            PolicyConfigurationFactory pcf;
            PolicyConfigurationFactory policyConfigurationFactory = pcf = this.getPolicyConfigurationFactory();
            synchronized (policyConfigurationFactory) {
                this.policyConfiguration = pcf.getPolicyConfiguration(this.contextId, false);
                if (this.metaData != null) {
                    this.createPermissions(this.metaData, this.policyConfiguration);
                } else {
                    EeLogger.ROOT_LOGGER.debugf("Cannot create permissions with 'null' metaData for id=%s", this.contextId);
                }
                if (!this.standalone.booleanValue()) {
                    PolicyConfiguration parent = (PolicyConfiguration)this.parentPolicy.getValue();
                    if (parent != null) {
                        parent = pcf.getPolicyConfiguration(parent.getContextID(), false);
                        parent.linkConfiguration(this.policyConfiguration);
                        this.policyConfiguration.commit();
                        parent.commit();
                    } else {
                        EeLogger.ROOT_LOGGER.debugf("Could not retrieve parent policy for policy %s", this.contextId);
                    }
                } else {
                    this.policyConfiguration.commit();
                }
                Policy.getPolicy().refresh();
            }
        }
        catch (Exception e) {
            throw EeLogger.ROOT_LOGGER.unableToStartException("JaccService", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolicyConfigurationFactory getPolicyConfigurationFactory() throws ModuleLoadException, ClassNotFoundException, PolicyContextException {
        ClassLoader originalClassLoader;
        String module = WildFlySecurityManager.getPropertyPrivileged((String)JACC_MODULE, null);
        if (module != null) {
            ModuleClassLoader jaccClassLoader = SecurityActions.getModuleClassLoader(module);
            originalClassLoader = SecurityActions.setThreadContextClassLoader((ClassLoader)jaccClassLoader);
        } else {
            Object jaccClassLoader = null;
            originalClassLoader = null;
        }
        try {
            PolicyConfigurationFactory policyConfigurationFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            return policyConfigurationFactory;
        }
        finally {
            if (originalClassLoader != null) {
                SecurityActions.setThreadContextClassLoader(originalClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        try {
            PolicyConfigurationFactory pcf;
            PolicyConfigurationFactory policyConfigurationFactory = pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            synchronized (policyConfigurationFactory) {
                this.policyConfiguration = pcf.getPolicyConfiguration(this.contextId, false);
                this.policyConfiguration.delete();
            }
        }
        catch (Exception e) {
            EeLogger.ROOT_LOGGER.errorDeletingJACCPolicy(e);
        }
        this.policyConfiguration = null;
    }

    public Injector<PolicyConfiguration> getParentPolicyInjector() {
        return this.parentPolicy;
    }

    public abstract void createPermissions(T var1, PolicyConfiguration var2) throws PolicyContextException;
}

