/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.apache.activemq.artemis.api.core.management.BaseBroadcastGroupControl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.AbstractActiveMQComponentControlHandler;

public class BroadcastGroupControlHandler
extends AbstractActiveMQComponentControlHandler<BaseBroadcastGroupControl> {
    public static final BroadcastGroupControlHandler INSTANCE = new BroadcastGroupControlHandler();

    private BroadcastGroupControlHandler() {
    }

    @Override
    protected BaseBroadcastGroupControl getActiveMQComponentControl(ActiveMQServer activeMQServer, PathAddress address) {
        String resourceName = address.getLastElement().getValue();
        return (BaseBroadcastGroupControl)BaseBroadcastGroupControl.class.cast(activeMQServer.getManagementService().getResource("broadcastgroup." + resourceName));
    }

    @Override
    protected String getDescriptionPrefix() {
        return "broadcast-group";
    }

    @Override
    protected Object handleOperation(String operationName, OperationContext context, ModelNode operation) throws OperationFailedException {
        if ("get-connector-pairs-as-json".equals(operationName)) {
            BaseBroadcastGroupControl control = (BaseBroadcastGroupControl)this.getActiveMQComponentControl(context, operation, false);
            try {
                context.getResult().set(control.getConnectorPairsAsJSON());
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
            }
        } else {
            this.unsupportedOperation(operationName);
        }
        return null;
    }
}

