/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.GlobalSecurityManager;
import org.infinispan.security.impl.Authorizer;
import org.infinispan.security.impl.CacheSubjectPair;
import org.infinispan.security.impl.SecurityActions;
import org.infinispan.security.impl.SubjectACL;
import org.infinispan.util.concurrent.CompletableFutures;

@MBean(objectName="GlobalSecurityManager", description="Controls global ACL caches")
@Scope(value=Scopes.GLOBAL)
public class GlobalSecurityManagerImpl
implements GlobalSecurityManager {
    private boolean cacheEnabled;
    private Cache<CacheSubjectPair, SubjectACL> cache;
    private EmbeddedCacheManager embeddedCacheManager;

    @Inject
    public void init(GlobalConfiguration globalConfiguration, EmbeddedCacheManager embeddedCacheManager, Authorizer authorizer) {
        long timeout = globalConfiguration.security().securityCacheTimeout();
        long size = globalConfiguration.security().securityCacheSize();
        if (timeout > 0L && size > 0L) {
            this.cache = Caffeine.newBuilder().maximumSize(size).expireAfterWrite(timeout, TimeUnit.MILLISECONDS).build();
            authorizer.setAclCache(this.cache.asMap());
            this.cacheEnabled = true;
        } else {
            this.cacheEnabled = false;
        }
        this.embeddedCacheManager = embeddedCacheManager;
    }

    public Map<?, ?> globalACLCache() {
        if (this.cacheEnabled) {
            return this.cache.asMap();
        }
        return null;
    }

    @Override
    @ManagedOperation(name="Flush ACL Cache", displayName="Flush ACL Cache", description="Flushes the global ACL cache across the entire cluster")
    public CompletionStage<Void> flushGlobalACLCache() {
        if (this.cacheEnabled) {
            ClusterExecutor executor = SecurityActions.getClusterExecutor(this.embeddedCacheManager);
            return executor.submitConsumer(cm -> {
                GlobalSecurityManager globalSecurityManager = SecurityActions.getGlobalComponentRegistry(cm).getComponent(GlobalSecurityManager.class);
                ((GlobalSecurityManagerImpl)globalSecurityManager).flushGlobalACLCache0();
                return null;
            }, (a, v, t) -> {});
        }
        return CompletableFutures.completedNull();
    }

    public void flushGlobalACLCache0() {
        if (this.cacheEnabled) {
            this.globalACLCache().clear();
        }
    }
}

