/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.toJavaPortable;

import com.sun.tools.corba.se.idl.GenFileStream;
import com.sun.tools.corba.se.idl.InterfaceEntry;
import com.sun.tools.corba.se.idl.InterfaceState;
import com.sun.tools.corba.se.idl.MethodEntry;
import com.sun.tools.corba.se.idl.PrimitiveEntry;
import com.sun.tools.corba.se.idl.SequenceEntry;
import com.sun.tools.corba.se.idl.StringEntry;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.TypedefEntry;
import com.sun.tools.corba.se.idl.ValueBoxEntry;
import com.sun.tools.corba.se.idl.ValueEntry;
import com.sun.tools.corba.se.idl.toJavaPortable.Arguments;
import com.sun.tools.corba.se.idl.toJavaPortable.Compile;
import com.sun.tools.corba.se.idl.toJavaPortable.Factories;
import com.sun.tools.corba.se.idl.toJavaPortable.JavaGenerator;
import com.sun.tools.corba.se.idl.toJavaPortable.MethodGen;
import com.sun.tools.corba.se.idl.toJavaPortable.TCOffsets;
import com.sun.tools.corba.se.idl.toJavaPortable.Util;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ValueGen
implements com.sun.tools.corba.se.idl.ValueGen,
JavaGenerator {
    protected int emit = 0;
    protected Factories factories = null;
    protected Hashtable symbolTable = null;
    protected ValueEntry v = null;
    protected PrintWriter stream = null;
    protected boolean explicitDefaultInit = false;

    @Override
    public void generate(Hashtable symbolTable, ValueEntry v, PrintWriter str) {
        this.symbolTable = symbolTable;
        this.v = v;
        this.init();
        this.openStream();
        if (this.stream == null) {
            return;
        }
        this.generateTie();
        this.generateHelper();
        this.generateHolder();
        this.writeHeading();
        this.writeBody();
        this.writeClosing();
        this.closeStream();
    }

    protected void init() {
        this.emit = ((Arguments)Compile.compiler.arguments).emit;
        this.factories = (Factories)Compile.compiler.factories();
    }

    protected void openStream() {
        this.stream = Util.stream(this.v, ".java");
    }

    protected void generateTie() {
        boolean tie = ((Arguments)Compile.compiler.arguments).TIEServer;
        if (this.v.supports().size() > 0 && tie) {
            Factories factories = (Factories)Compile.compiler.factories();
            factories.skeleton().generate(this.symbolTable, this.v);
        }
    }

    protected void generateHelper() {
        ((Factories)Compile.compiler.factories()).helper().generate(this.symbolTable, this.v);
    }

    protected void generateHolder() {
        ((Factories)Compile.compiler.factories()).holder().generate(this.symbolTable, this.v);
    }

    protected void writeHeading() {
        Util.writePackage(this.stream, this.v);
        Util.writeProlog(this.stream, ((GenFileStream)this.stream).name());
        if (this.v.comment() != null) {
            this.v.comment().generate("", this.stream);
        }
        if (this.v.isAbstract()) {
            this.writeAbstract();
            return;
        }
        this.stream.print("public class " + this.v.name());
        SymtabEntry parent = (SymtabEntry)this.v.derivedFrom().elementAt(0);
        String parentName = Util.javaName(parent);
        boolean impl = false;
        if (parentName.equals("java.io.Serializable")) {
            this.stream.print(" implements org.omg.CORBA.portable.ValueBase");
            impl = true;
        } else if (!((ValueEntry)parent).isAbstract()) {
            this.stream.print(" extends " + parentName);
        }
        for (int i = 0; i < this.v.derivedFrom().size(); ++i) {
            parent = (SymtabEntry)this.v.derivedFrom().elementAt(i);
            if (!((ValueEntry)parent).isAbstract()) continue;
            if (!impl) {
                this.stream.print(" implements ");
                impl = true;
            } else {
                this.stream.print(", ");
            }
            this.stream.print(Util.javaName(parent));
        }
        if (this.v.supports().size() > 0) {
            if (!impl) {
                this.stream.print(" implements ");
                impl = true;
            } else {
                this.stream.print(", ");
            }
            InterfaceEntry s = (InterfaceEntry)this.v.supports().elementAt(0);
            if (s.isAbstract()) {
                this.stream.print(Util.javaName(s));
            } else {
                this.stream.print(Util.javaName(s) + "Operations");
            }
        }
        if (this.v.isCustom()) {
            if (!impl) {
                this.stream.print(" implements ");
                impl = true;
            } else {
                this.stream.print(", ");
            }
            this.stream.print("org.omg.CORBA.CustomMarshal ");
        }
        this.stream.println();
        this.stream.println("{");
    }

    protected void writeBody() {
        this.writeMembers();
        this.writeInitializers();
        this.writeConstructor();
        this.writeTruncatable();
        this.writeMethods();
    }

    protected void writeClosing() {
        if (this.v.isAbstract()) {
            this.stream.println("} // interface " + this.v.name());
        } else {
            this.stream.println("} // class " + this.v.name());
        }
    }

    protected void closeStream() {
        this.stream.close();
    }

    protected void writeConstructor() {
        if (!this.v.isAbstract() && !this.explicitDefaultInit) {
            this.stream.println("  protected " + this.v.name() + " () {}");
            this.stream.println();
        }
    }

    protected void writeTruncatable() {
        if (!this.v.isAbstract()) {
            this.stream.println("  public String[] _truncatable_ids() {");
            this.stream.println("      return " + Util.helperName(this.v, true) + ".get_instance().get_truncatable_base_ids();");
            this.stream.println("  }");
            this.stream.println();
        }
    }

    protected void writeMembers() {
        if (this.v.state() == null) {
            return;
        }
        for (int i = 0; i < this.v.state().size(); ++i) {
            InterfaceState member = (InterfaceState)this.v.state().elementAt(i);
            TypedefEntry entry = member.entry;
            Util.fillInfo(entry);
            if (entry.comment() != null) {
                entry.comment().generate(" ", this.stream);
            }
            String modifier = "  ";
            if (member.modifier == 2) {
                modifier = "  public ";
            }
            Util.writeInitializer(modifier, entry.name(), "", entry, this.stream);
        }
    }

    protected void writeInitializers() {
        Vector init = this.v.initializers();
        if (init != null) {
            this.stream.println();
            for (int i = 0; i < init.size(); ++i) {
                MethodEntry element = (MethodEntry)init.elementAt(i);
                element.valueMethod(true);
                ((MethodGen)element.generator()).interfaceMethod(this.symbolTable, element, this.stream);
                if (!element.parameters().isEmpty()) continue;
                this.explicitDefaultInit = true;
            }
        }
    }

    protected void writeMethods() {
        Enumeration e = this.v.contained().elements();
        while (e.hasMoreElements()) {
            SymtabEntry contained = (SymtabEntry)e.nextElement();
            if (contained instanceof MethodEntry) {
                MethodEntry element = (MethodEntry)contained;
                ((MethodGen)element.generator()).interfaceMethod(this.symbolTable, element, this.stream);
                continue;
            }
            if (contained instanceof TypedefEntry) {
                contained.type().generate(this.symbolTable, this.stream);
            }
            contained.generate(this.symbolTable, this.stream);
        }
        if (this.v.isAbstract()) {
            return;
        }
        if (this.v.supports().size() > 0) {
            InterfaceEntry intf = (InterfaceEntry)this.v.supports().elementAt(0);
            Enumeration el = intf.allMethods().elements();
            while (el.hasMoreElements()) {
                MethodEntry m = (MethodEntry)el.nextElement();
                MethodEntry mClone = (MethodEntry)m.clone();
                mClone.container(this.v);
                ((MethodGen)mClone.generator()).interfaceMethod(this.symbolTable, mClone, this.stream);
            }
        }
        for (int i = 0; i < this.v.derivedFrom().size(); ++i) {
            ValueEntry parentValue = (ValueEntry)this.v.derivedFrom().elementAt(i);
            if (!parentValue.isAbstract()) continue;
            Enumeration el = parentValue.allMethods().elements();
            while (el.hasMoreElements()) {
                MethodEntry m = (MethodEntry)el.nextElement();
                MethodEntry mClone = (MethodEntry)m.clone();
                mClone.container(this.v);
                ((MethodGen)mClone.generator()).interfaceMethod(this.symbolTable, mClone, this.stream);
            }
        }
    }

    protected void writeStreamableMethods() {
        this.stream.println("  public void _read (org.omg.CORBA.portable.InputStream istream)");
        this.stream.println("  {");
        this.read(0, "    ", "this", this.v, this.stream);
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  public void _write (org.omg.CORBA.portable.OutputStream ostream)");
        this.stream.println("  {");
        this.write(0, "    ", "this", this.v, this.stream);
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  public org.omg.CORBA.TypeCode _type ()");
        this.stream.println("  {");
        this.stream.println("    return " + Util.helperName(this.v, false) + ".type ();");
        this.stream.println("  }");
    }

    @Override
    public int helperType(int index, String indent, TCOffsets tcoffsets, String name, SymtabEntry entry, PrintWriter stream) {
        ValueEntry vt = (ValueEntry)entry;
        Vector state = vt.state();
        int noOfMembers = state == null ? 0 : state.size();
        String members = "_members" + index++;
        String tcOfMembers = "_tcOf" + members;
        stream.println(indent + "org.omg.CORBA.ValueMember[] " + members + " = new org.omg.CORBA.ValueMember[" + noOfMembers + "];");
        stream.println(indent + "org.omg.CORBA.TypeCode " + tcOfMembers + " = null;");
        String definedInrepId = "_id";
        for (int k = 0; k < noOfMembers; ++k) {
            String version;
            String repId;
            InterfaceState valueMember = (InterfaceState)state.elementAt(k);
            TypedefEntry member = valueMember.entry;
            SymtabEntry mType = Util.typeOf(member);
            if (ValueGen.hasRepId(member)) {
                repId = Util.helperName(mType, true) + ".id ()";
                if (mType instanceof ValueEntry || mType instanceof ValueBoxEntry) {
                    version = "\"\"";
                } else {
                    String id = mType.repositoryID().ID();
                    version = '\"' + id.substring(id.lastIndexOf(58) + 1) + '\"';
                }
            } else {
                repId = "\"\"";
                version = "\"\"";
            }
            stream.println(indent + "// ValueMember instance for " + member.name());
            index = ((JavaGenerator)((Object)member.generator())).type(index, indent, tcoffsets, tcOfMembers, member, stream);
            stream.println(indent + members + "[" + k + "] = new org.omg.CORBA.ValueMember (" + '\"' + member.name() + "\", ");
            stream.println(indent + "    " + repId + ", ");
            stream.println(indent + "    " + definedInrepId + ", ");
            stream.println(indent + "    " + version + ", ");
            stream.println(indent + "    " + tcOfMembers + ", ");
            stream.println(indent + "    null, ");
            stream.println(indent + "    org.omg.CORBA." + (valueMember.modifier == 2 ? "PUBLIC_MEMBER" : "PRIVATE_MEMBER") + ".value);");
        }
        stream.println(indent + name + " = org.omg.CORBA.ORB.init ().create_value_tc (_id, " + '\"' + entry.name() + "\", " + ValueGen.getValueModifier(vt) + ", " + ValueGen.getConcreteBaseTypeCode(vt) + ", " + members + ");");
        return index;
    }

    @Override
    public int type(int index, String indent, TCOffsets tcoffsets, String name, SymtabEntry entry, PrintWriter stream) {
        stream.println(indent + name + " = " + Util.helperName(entry, true) + ".type ();");
        return index;
    }

    private static boolean hasRepId(SymtabEntry member) {
        SymtabEntry mType = Util.typeOf(member);
        return !(mType instanceof PrimitiveEntry || mType instanceof StringEntry || mType instanceof TypedefEntry && !((TypedefEntry)mType).arrayInfo().isEmpty() || mType instanceof TypedefEntry && member.type() instanceof SequenceEntry);
    }

    private static String getValueModifier(ValueEntry vt) {
        String mod = "NONE";
        if (vt.isCustom()) {
            mod = "CUSTOM";
        } else if (vt.isAbstract()) {
            mod = "ABSTRACT";
        } else if (vt.isSafe()) {
            mod = "TRUNCATABLE";
        }
        return "org.omg.CORBA.VM_" + mod + ".value";
    }

    private static String getConcreteBaseTypeCode(ValueEntry vt) {
        SymtabEntry base;
        Vector v = vt.derivedFrom();
        if (!vt.isAbstract() && !"ValueBase".equals((base = (SymtabEntry)vt.derivedFrom().elementAt(0)).name())) {
            return Util.helperName(base, true) + ".type ()";
        }
        return "null";
    }

    @Override
    public void helperRead(String entryName, SymtabEntry entry, PrintWriter stream) {
        if (((ValueEntry)entry).isAbstract()) {
            stream.println("    throw new org.omg.CORBA.BAD_OPERATION (\"abstract value cannot be instantiated\");");
        } else {
            stream.println("    return (" + entryName + ") ((org.omg.CORBA_2_3.portable.InputStream) istream).read_value (get_instance());");
        }
        stream.println("  }");
        stream.println();
        stream.println("  public java.io.Serializable read_value (org.omg.CORBA.portable.InputStream istream)");
        stream.println("  {");
        if (((ValueEntry)entry).isAbstract()) {
            stream.println("    throw new org.omg.CORBA.BAD_OPERATION (\"abstract value cannot be instantiated\");");
        } else if (((ValueEntry)entry).isCustom()) {
            stream.println("    throw new org.omg.CORBA.BAD_OPERATION (\"custom values should use unmarshal()\");");
        } else {
            stream.println("    " + entryName + " value = new " + entryName + " ();");
            this.read(0, "    ", "value", entry, stream);
            stream.println("    return value;");
        }
        stream.println("  }");
        stream.println();
        stream.println("  public static void read (org.omg.CORBA.portable.InputStream istream, " + entryName + " value)");
        stream.println("  {");
        this.read(0, "    ", "value", entry, stream);
    }

    @Override
    public int read(int index, String indent, String name, SymtabEntry entry, PrintWriter stream) {
        Vector vMembers;
        Vector vParents = ((ValueEntry)entry).derivedFrom();
        if (vParents != null && vParents.size() != 0) {
            ValueEntry parent = (ValueEntry)vParents.elementAt(0);
            if (parent == null) {
                return index;
            }
            if (!Util.javaQualifiedName(parent).equals("java.io.Serializable")) {
                stream.println(indent + Util.helperName(parent, true) + ".read (istream, value);");
            }
        }
        int noOfMembers = (vMembers = ((ValueEntry)entry).state()) == null ? 0 : vMembers.size();
        for (int k = 0; k < noOfMembers; ++k) {
            TypedefEntry member = ((InterfaceState)vMembers.elementAt((int)k)).entry;
            String memberName = member.name();
            SymtabEntry mType = member.type();
            if (mType instanceof PrimitiveEntry || mType instanceof TypedefEntry || mType instanceof SequenceEntry || mType instanceof StringEntry || !member.arrayInfo().isEmpty()) {
                index = ((JavaGenerator)((Object)member.generator())).read(index, indent, name + '.' + memberName, member, stream);
                continue;
            }
            if (mType instanceof ValueEntry) {
                String returnType = Util.javaQualifiedName(mType);
                if (mType instanceof ValueBoxEntry) {
                    returnType = Util.javaName(mType);
                }
                stream.println("    " + name + '.' + memberName + " = (" + returnType + ") ((org.omg.CORBA_2_3.portable.InputStream)istream).read_value (" + Util.helperName(mType, true) + ".get_instance ());");
                continue;
            }
            stream.println(indent + name + '.' + memberName + " = " + Util.helperName(mType, true) + ".read (istream);");
        }
        return index;
    }

    @Override
    public void helperWrite(SymtabEntry entry, PrintWriter stream) {
        stream.println("    ((org.omg.CORBA_2_3.portable.OutputStream) ostream).write_value (value, get_instance());");
        stream.println("  }");
        stream.println();
        if (!((ValueEntry)entry).isCustom()) {
            stream.println("  public static void _write (org.omg.CORBA.portable.OutputStream ostream, " + Util.javaName(entry) + " value)");
            stream.println("  {");
            this.write(0, "    ", "value", entry, stream);
            stream.println("  }");
            stream.println();
        }
        stream.println("  public void write_value (org.omg.CORBA.portable.OutputStream ostream, java.io.Serializable obj)");
        stream.println("  {");
        if (((ValueEntry)entry).isCustom()) {
            stream.println("    throw new org.omg.CORBA.BAD_OPERATION (\"custom values should use marshal()\");");
        } else {
            String entryName = Util.javaName(entry);
            stream.println("    _write (ostream, (" + entryName + ") obj);");
        }
    }

    @Override
    public int write(int index, String indent, String name, SymtabEntry entry, PrintWriter stream) {
        Vector vMembers;
        Vector vParents = ((ValueEntry)entry).derivedFrom();
        if (vParents != null && vParents.size() != 0) {
            ValueEntry parent = (ValueEntry)vParents.elementAt(0);
            if (parent == null) {
                return index;
            }
            if (!Util.javaQualifiedName(parent).equals("java.io.Serializable")) {
                stream.println(indent + Util.helperName(parent, true) + "._write (ostream, value);");
            }
        }
        int noOfMembers = (vMembers = ((ValueEntry)entry).state()) == null ? 0 : vMembers.size();
        for (int k = 0; k < noOfMembers; ++k) {
            TypedefEntry member = ((InterfaceState)vMembers.elementAt((int)k)).entry;
            String memberName = member.name();
            SymtabEntry mType = member.type();
            if (mType instanceof PrimitiveEntry || mType instanceof TypedefEntry || mType instanceof SequenceEntry || mType instanceof StringEntry || !member.arrayInfo().isEmpty()) {
                index = ((JavaGenerator)((Object)member.generator())).write(index, indent, name + '.' + memberName, member, stream);
                continue;
            }
            stream.println(indent + Util.helperName(mType, true) + ".write (ostream, " + name + '.' + memberName + ");");
        }
        return index;
    }

    protected void writeAbstract() {
        this.stream.print("public interface " + this.v.name());
        if (this.v.derivedFrom().size() == 0) {
            this.stream.print(" extends org.omg.CORBA.portable.ValueBase");
        } else {
            for (int i = 0; i < this.v.derivedFrom().size(); ++i) {
                if (i == 0) {
                    this.stream.print(" extends ");
                } else {
                    this.stream.print(", ");
                }
                SymtabEntry parent = (SymtabEntry)this.v.derivedFrom().elementAt(i);
                this.stream.print(Util.javaName(parent));
            }
        }
        if (this.v.supports().size() > 0) {
            this.stream.print(", ");
            SymtabEntry intf = (SymtabEntry)this.v.supports().elementAt(0);
            this.stream.print(Util.javaName(intf));
        }
        this.stream.println();
        this.stream.println("{");
    }
}

