/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.cdi;

import io.smallrye.jwt.auth.cdi.CDILogging;
import io.smallrye.jwt.auth.cdi.ClaimValueProducer;
import io.smallrye.jwt.auth.cdi.CommonJwtProducer;
import io.smallrye.jwt.auth.cdi.JWTCallerPrincipalFactoryProducer;
import io.smallrye.jwt.auth.cdi.JsonValueProducer;
import io.smallrye.jwt.auth.cdi.OptionalClaimTypeProducer;
import io.smallrye.jwt.auth.cdi.PrincipalProducer;
import io.smallrye.jwt.auth.cdi.RawClaimTypeProducer;
import io.smallrye.jwt.auth.jaxrs.JWTAuthenticationFilter;
import io.smallrye.jwt.auth.mechanism.JWTHttpAuthenticationMechanism;
import io.smallrye.jwt.auth.principal.DefaultJWTParser;
import io.smallrye.jwt.config.JWTAuthContextInfoProvider;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;

public class SmallRyeJWTAuthCDIExtension
implements Extension {
    private static final String HTTP_AUTH_MECHANISM_CLASS_NAME = "javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism";

    private static boolean isEESecurityAvailable() {
        try {
            Class.forName(HTTP_AUTH_MECHANISM_CLASS_NAME);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected boolean registerOptionalClaimTypeProducer() {
        return false;
    }

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        CDILogging.log.beforeBeanDiscovery(beanManager);
        this.addAnnotatedType(event, beanManager, ClaimValueProducer.class);
        this.addAnnotatedType(event, beanManager, CommonJwtProducer.class);
        this.addAnnotatedType(event, beanManager, DefaultJWTParser.class);
        this.addAnnotatedType(event, beanManager, JWTCallerPrincipalFactoryProducer.class);
        this.addAnnotatedType(event, beanManager, JsonValueProducer.class);
        this.addAnnotatedType(event, beanManager, JWTAuthContextInfoProvider.class);
        this.addAnnotatedType(event, beanManager, PrincipalProducer.class);
        this.addAnnotatedType(event, beanManager, RawClaimTypeProducer.class);
        if (this.registerOptionalClaimTypeProducer()) {
            this.addAnnotatedType(event, beanManager, OptionalClaimTypeProducer.class);
        }
        if (SmallRyeJWTAuthCDIExtension.isEESecurityAvailable()) {
            this.addAnnotatedType(event, beanManager, JWTHttpAuthenticationMechanism.class);
            CDILogging.log.jwtHttpAuthenticationMechanismRegistered();
        } else {
            this.addAnnotatedType(event, beanManager, JWTAuthenticationFilter.class);
            CDILogging.log.jwtHttpAuthenticationMechanismNotRegistered();
        }
    }

    void addAnnotatedType(BeforeBeanDiscovery event, BeanManager beanManager, Class<?> type) {
        String id = "SmallRye" + type.getSimpleName();
        event.addAnnotatedType(beanManager.createAnnotatedType(type), id);
        CDILogging.log.addedType(type.getName());
    }
}

