/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.inject;

import java.lang.reflect.Field;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.inject.InjectorLogger;
import org.jboss.msc.value.Value;

@Deprecated
public final class FieldInjector<T>
implements Injector<T> {
    private final Value<?> target;
    private final Field field;

    public FieldInjector(Value<?> target, Field field) {
        this.target = target;
        this.field = field;
    }

    @Override
    public void inject(T value) {
        try {
            this.field.set(this.target.getValue(), value);
        }
        catch (Exception e) {
            throw new InjectionException("Failed to inject value into field", e);
        }
    }

    @Override
    public void uninject() {
        Field field = this.field;
        try {
            Class<?> fieldType = field.getType();
            Object targetValue = this.target.getValue();
            if (fieldType.isPrimitive()) {
                this.uninjectPrimitive(field, fieldType, targetValue);
            } else {
                field.set(targetValue, null);
            }
        }
        catch (Throwable throwable) {
            InjectorLogger.INSTANCE.uninjectFailed(throwable, field);
        }
    }

    private void uninjectPrimitive(Field field, Class<?> fieldType, Object targetValue) throws IllegalArgumentException, IllegalAccessException {
        switch (fieldType.getName().toString().charAt(0)) {
            case 'b': {
                if (fieldType == Byte.TYPE) {
                    field.setByte(targetValue, (byte)0);
                    break;
                }
                field.setBoolean(targetValue, false);
                break;
            }
            case 'c': {
                field.setChar(targetValue, '\u0000');
                break;
            }
            case 'd': {
                field.setDouble(targetValue, 0.0);
                break;
            }
            case 'f': {
                field.setFloat(targetValue, 0.0f);
                break;
            }
            case 'i': {
                field.setInt(targetValue, 0);
                break;
            }
            case 'l': {
                field.setLong(targetValue, 0L);
                break;
            }
            case 's': {
                field.setShort(targetValue, (short)0);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected field primitive type " + fieldType.getName());
            }
        }
    }
}

