/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx.model;

import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.ReadResourceDescriptionHandler;
import org.jboss.as.jmx.logging.JmxLogger;
import org.jboss.dmr.ModelNode;

class ResourceAccessControlUtil {
    private static final ResourceAccessControl NOT_ADDRESSABLE;
    private final ModelController controller;

    ResourceAccessControlUtil(ModelController controller) {
        this.controller = controller;
    }

    ResourceAccessControl getResourceAccessWithInstanceNotFoundExceptionIfNotAccessible(ObjectName name, PathAddress address, boolean operations) throws InstanceNotFoundException {
        ResourceAccessControl accessControl = this.getResourceAccess(address, operations);
        if (!accessControl.isAccessibleResource()) {
            throw JmxLogger.ROOT_LOGGER.mbeanNotFound(name);
        }
        return accessControl;
    }

    ResourceAccessControl getResourceAccess(PathAddress address, boolean operations) {
        String key;
        ModelNode exception;
        ModelNode result;
        ModelNode op = Util.createOperation((String)"read-resource-description", (PathAddress)address);
        op.get("access-control").set(ReadResourceDescriptionHandler.AccessControl.TRIM_DESCRIPTONS.toModelNode());
        if (operations) {
            op.get("operations").set(true);
            op.get("inherited").set(false);
        }
        if (!(result = this.controller.execute(op, null, ModelController.OperationTransactionControl.COMMIT, null)).get("outcome").asString().equals("success")) {
            return NOT_ADDRESSABLE;
        }
        ModelNode accessControl = result.get(new String[]{"result", "access-control"});
        ModelNode useAccessControl = null;
        if (accessControl.hasDefined("exceptions") && !accessControl.get("exceptions").keys().isEmpty() && (exception = accessControl.get(new String[]{"exceptions", key = address.toModelNode().asString()})).isDefined()) {
            useAccessControl = exception;
        }
        if (useAccessControl == null) {
            useAccessControl = accessControl.get("default");
        }
        return new ResourceAccessControl(useAccessControl);
    }

    static {
        ModelNode notAddressable = new ModelNode();
        notAddressable.get("address").set(false);
        notAddressable.protect();
        NOT_ADDRESSABLE = new ResourceAccessControl(notAddressable);
    }

    static class ResourceAccessControl {
        private final ModelNode accessControl;

        ResourceAccessControl(ModelNode modelNode) {
            this.accessControl = modelNode;
        }

        boolean isAccessibleResource() {
            return !this.accessControl.hasDefined("address") || this.accessControl.get("address").asBoolean();
        }

        public boolean isReadableAttribute(String attribute) {
            ModelNode node = this.accessControl.get(new String[]{"attributes", attribute, "read"});
            if (!node.isDefined()) {
                return false;
            }
            return node.asBoolean();
        }

        public boolean isWritableAttribute(String attribute) {
            ModelNode node = this.accessControl.get(new String[]{"attributes", attribute, "write"});
            if (!node.isDefined()) {
                return false;
            }
            return node.asBoolean();
        }

        public boolean isExecutableOperation(String operation) {
            ModelNode node = this.accessControl.get(new String[]{"operations", operation, "execute"});
            if (!node.isDefined()) {
                return false;
            }
            return node.asBoolean();
        }
    }
}

