/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.time.Duration;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.infinispan.InfinispanCacheProperties;
import org.wildfly.clustering.ejb.BeanManager;
import org.wildfly.clustering.ejb.BeanManagerFactory;
import org.wildfly.clustering.ejb.BeanPassivationConfiguration;
import org.wildfly.clustering.ejb.PassivationListener;
import org.wildfly.clustering.ejb.RemoveListener;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanFilter;
import org.wildfly.clustering.ejb.infinispan.BeanKey;
import org.wildfly.clustering.ejb.infinispan.Configuration;
import org.wildfly.clustering.ejb.infinispan.ExpirationConfiguration;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManager;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManagerConfiguration;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManagerFactoryConfiguration;
import org.wildfly.clustering.ejb.infinispan.PassivationConfiguration;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanFactory;
import org.wildfly.clustering.ejb.infinispan.group.InfinispanBeanGroupFactory;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.marshalling.jboss.JBossByteBufferMarshaller;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshalledValueFactory;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.spi.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.spi.group.Group;

public class InfinispanBeanManagerFactory<I, T>
implements BeanManagerFactory<I, T, TransactionBatch> {
    private final InfinispanBeanManagerFactoryConfiguration configuration;

    public InfinispanBeanManagerFactory(InfinispanBeanManagerFactoryConfiguration configuration) {
        this.configuration = configuration;
    }

    public BeanManager<I, T, TransactionBatch> createBeanManager(Supplier<I> identifierFactory, final PassivationListener<T> passivationListener, final RemoveListener<T> removeListener) {
        JBossByteBufferMarshaller marshaller = new JBossByteBufferMarshaller(this.configuration.getMarshallingConfigurationRepository(), (ClassLoader)this.configuration.getBeanConfiguration().getModule().getClassLoader());
        ByteBufferMarshalledValueFactory factory = new ByteBufferMarshalledValueFactory((ByteBufferMarshaller)marshaller);
        Cache beanCache = this.configuration.getCache();
        Cache groupCache = this.configuration.getCache();
        InfinispanCacheProperties properties = new InfinispanCacheProperties(groupCache.getCacheConfiguration());
        String beanName = this.configuration.getBeanConfiguration().getName();
        final BeanPassivationConfiguration passivationConfig = this.configuration.getPassivationConfiguration();
        PassivationConfiguration passivation = new PassivationConfiguration<T>(){

            @Override
            public PassivationListener<T> getPassivationListener() {
                return passivationListener;
            }

            @Override
            public BeanPassivationConfiguration getConfiguration() {
                return passivationConfig;
            }
        };
        BeanFilter beanFilter = new BeanFilter(beanName);
        InfinispanBeanGroupFactory groupFactory = new InfinispanBeanGroupFactory(groupCache, beanCache, beanFilter, factory, (CacheProperties)properties, passivation);
        SimpleConfiguration groupConfiguration = new SimpleConfiguration(groupCache, groupFactory);
        InfinispanBeanFactory beanFactory = new InfinispanBeanFactory(beanName, groupFactory, beanCache, (CacheProperties)properties, this.configuration.getBeanConfiguration().getTimeout(), properties.isPersistent() ? passivationListener : null);
        SimpleConfiguration beanConfiguration = new SimpleConfiguration(beanCache, beanFactory);
        Group<Address> group = this.configuration.getGroup();
        KeyAffinityServiceFactory affinityFactory = this.configuration.getKeyAffinityServiceFactory();
        CommandDispatcherFactory dispatcherFactory = this.configuration.getCommandDispatcherFactory();
        final Duration timeout = this.configuration.getBeanConfiguration().getTimeout();
        ExpirationConfiguration expiration = new ExpirationConfiguration<T>(){

            @Override
            public Duration getTimeout() {
                return timeout;
            }

            @Override
            public RemoveListener<T> getRemoveListener() {
                return removeListener;
            }
        };
        final String name = this.configuration.getName();
        InfinispanBeanManagerConfiguration configuration = new InfinispanBeanManagerConfiguration<I, T>((Predicate)beanFilter, affinityFactory, (Group)group, dispatcherFactory, expiration, passivation, (CacheProperties)properties){
            final /* synthetic */ Predicate val$beanFilter;
            final /* synthetic */ KeyAffinityServiceFactory val$affinityFactory;
            final /* synthetic */ Group val$group;
            final /* synthetic */ CommandDispatcherFactory val$dispatcherFactory;
            final /* synthetic */ ExpirationConfiguration val$expiration;
            final /* synthetic */ PassivationConfiguration val$passivation;
            final /* synthetic */ CacheProperties val$properties;
            {
                this.val$beanFilter = predicate;
                this.val$affinityFactory = keyAffinityServiceFactory;
                this.val$group = group;
                this.val$dispatcherFactory = commandDispatcherFactory;
                this.val$expiration = expirationConfiguration;
                this.val$passivation = passivationConfiguration;
                this.val$properties = cacheProperties;
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Predicate<Map.Entry<? super BeanKey<I>, ? super BeanEntry<I>>> getBeanFilter() {
                return this.val$beanFilter;
            }

            @Override
            public KeyAffinityServiceFactory getAffinityFactory() {
                return this.val$affinityFactory;
            }

            @Override
            public Group<Address> getGroup() {
                return this.val$group;
            }

            @Override
            public CommandDispatcherFactory getCommandDispatcherFactory() {
                return this.val$dispatcherFactory;
            }

            @Override
            public ExpirationConfiguration<T> getExpirationConfiguration() {
                return this.val$expiration;
            }

            @Override
            public PassivationConfiguration<T> getPassivationConfiguration() {
                return this.val$passivation;
            }

            @Override
            public CacheProperties getProperties() {
                return this.val$properties;
            }
        };
        return new InfinispanBeanManager(configuration, identifierFactory, beanConfiguration, groupConfiguration);
    }

    private static class SimpleConfiguration<K, V, F>
    implements Configuration<K, V, F> {
        private final F factory;
        private final Cache<K, V> cache;

        SimpleConfiguration(Cache<K, V> cache, F factory) {
            this.factory = factory;
            this.cache = cache;
        }

        @Override
        public F getFactory() {
            return this.factory;
        }

        @Override
        public Cache<K, V> getCache() {
            return this.cache;
        }
    }
}

