/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.identity;

import java.security.Principal;
import java.security.cert.X509Certificate;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.IdentityType;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.extensions.CertificateIdentityFactory;
import org.jboss.security.identity.extensions.CredentialIdentityFactory;

public class IdentityFactory {
    public static IdentityFactory getFactory(IdentityType type) {
        if (type == IdentityType.CREDENTIAL) {
            return CredentialIdentityFactory.getInstance();
        }
        if (type == IdentityType.CERTIFICATE) {
            return CertificateIdentityFactory.getInstance();
        }
        throw PicketBoxMessages.MESSAGES.identityTypeFactoryNotImplemented(type != null ? type.name() : null);
    }

    public static Identity getIdentity(Principal principal, Object credential) {
        return CredentialIdentityFactory.createIdentity(principal, credential);
    }

    public static Identity getIdentity(Principal principal, X509Certificate[] certs, Role roles) {
        CertificateIdentityFactory identityFactory = CertificateIdentityFactory.getInstance();
        return identityFactory.createIdentity(principal, certs, roles);
    }
}

