/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.infinispan.util.concurrent.CountDownRunnable;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.irac.IracBatchSendResult;
import org.infinispan.xsite.status.DefaultTakeOfflineManager;

public class IracClearResponseCollector
implements Runnable {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final AtomicReferenceFieldUpdater<IracClearResponseCollector, IracBatchSendResult> RESULT_UPDATED = AtomicReferenceFieldUpdater.newUpdater(IracClearResponseCollector.class, IracBatchSendResult.class, "result");
    private volatile IracBatchSendResult result = IracBatchSendResult.OK;
    private final CountDownRunnable countDownRunnable;
    private final CompletableFuture<IracBatchSendResult> complete = new CompletableFuture();

    public IracClearResponseCollector() {
        this.countDownRunnable = new CountDownRunnable(this);
    }

    public void dependsOn(XSiteBackup backup, CompletionStage<Void> request) {
        this.countDownRunnable.increment();
        request.whenComplete((bitSet, throwable) -> this.onResponse(backup, (Throwable)throwable));
    }

    public CompletionStage<IracBatchSendResult> freeze() {
        this.countDownRunnable.freeze();
        return this.complete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onResponse(XSiteBackup backup, Throwable throwable) {
        try {
            boolean trace = log.isTraceEnabled();
            if (throwable != null) {
                if (DefaultTakeOfflineManager.isCommunicationError(throwable)) {
                    RESULT_UPDATED.set(this, IracBatchSendResult.BACK_OFF_AND_RETRY);
                } else {
                    RESULT_UPDATED.compareAndSet(this, IracBatchSendResult.OK, IracBatchSendResult.RETRY);
                }
            } else if (trace) {
                log.tracef("Received clear response from %s (%d remaining)", backup.getSiteName(), this.countDownRunnable.missing());
            }
        }
        finally {
            this.countDownRunnable.decrement();
        }
    }

    @Override
    public void run() {
        this.complete.complete(this.result);
    }
}

