/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.shallow;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.operations.global.ListOperations;
import org.jboss.as.controller.operations.global.MapOperations;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.wildfly.extension.messaging.activemq.shallow.IgnoredAttributeProvider;
import org.wildfly.extension.messaging.activemq.shallow.OperationAddressConverter;
import org.wildfly.extension.messaging.activemq.shallow.TranslatedOperationHandler;
import org.wildfly.extension.messaging.activemq.shallow.TranslatedReadAttributeHandler;
import org.wildfly.extension.messaging.activemq.shallow.TranslatedWriteAttributeHandler;

public abstract class ShallowResourceDefinition
extends PersistentResourceDefinition
implements OperationAddressConverter,
IgnoredAttributeProvider {
    protected final boolean registerRuntimeOnly;

    public ShallowResourceDefinition(SimpleResourceDefinition.Parameters parameters, boolean registerRuntimeOnly) {
        super(parameters);
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        TranslatedOperationHandler handler = new TranslatedOperationHandler(this);
        resourceRegistration.registerOperationHandler(MapOperations.MAP_CLEAR_DEFINITION, (OperationStepHandler)handler);
        resourceRegistration.registerOperationHandler(MapOperations.MAP_PUT_DEFINITION, (OperationStepHandler)handler);
        resourceRegistration.registerOperationHandler(MapOperations.MAP_GET_DEFINITION, (OperationStepHandler)handler);
        resourceRegistration.registerOperationHandler(MapOperations.MAP_REMOVE_DEFINITION, (OperationStepHandler)handler);
        resourceRegistration.registerOperationHandler(ListOperations.LIST_ADD_DEFINITION, (OperationStepHandler)handler);
        resourceRegistration.registerOperationHandler(ListOperations.LIST_GET_DEFINITION, (OperationStepHandler)handler);
        resourceRegistration.registerOperationHandler(ListOperations.LIST_REMOVE_DEFINITION, (OperationStepHandler)handler);
        resourceRegistration.registerOperationHandler(ListOperations.LIST_CLEAR_DEFINITION, (OperationStepHandler)handler);
        super.registerOperations(resourceRegistration);
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        for (AttributeDefinition attr : this.getAttributes()) {
            if (this.registerRuntimeOnly || !attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) {
                registry.registerReadWriteAttribute(attr, (OperationStepHandler)new TranslatedReadAttributeHandler(this, this), (OperationStepHandler)new TranslatedWriteAttributeHandler(this));
                continue;
            }
            registry.registerReadOnlyAttribute(attr, (OperationStepHandler)new TranslatedReadAttributeHandler(this, this));
        }
    }
}

