/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events.configurator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.configurator.BeanAttributesConfigurator;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Named;
import org.jboss.weld.bean.attributes.ImmutableBeanAttributes;
import org.jboss.weld.bootstrap.events.configurator.Configurator;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.metadata.cache.StereotypeModel;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Bindings;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.HierarchyDiscovery;

public class BeanAttributesConfiguratorImpl<T>
implements BeanAttributesConfigurator<T>,
Configurator<BeanAttributes<T>> {
    private final BeanManagerImpl beanManager;
    private String name;
    final Set<Annotation> qualifiers;
    private Class<? extends Annotation> scope;
    private final Set<Class<? extends Annotation>> stereotypes;
    final Set<Type> types;
    private boolean isAlternative;

    public BeanAttributesConfiguratorImpl(BeanManagerImpl beanManager) {
        this.beanManager = beanManager;
        this.qualifiers = new HashSet<Annotation>();
        this.types = new HashSet<Type>();
        this.types.add((Type)((Object)Object.class));
        this.stereotypes = new HashSet<Class<? extends Annotation>>();
    }

    public BeanAttributesConfiguratorImpl(BeanAttributes<T> beanAttributes, BeanManagerImpl beanManager) {
        this(beanManager);
        this.read(beanAttributes);
    }

    public BeanAttributesConfigurator<T> read(BeanAttributes<?> beanAttributes) {
        Preconditions.checkArgumentNotNull(beanAttributes);
        this.name(beanAttributes.getName());
        this.qualifiers(beanAttributes.getQualifiers());
        this.scope(beanAttributes.getScope());
        this.stereotypes(beanAttributes.getStereotypes());
        this.types(beanAttributes.getTypes());
        this.alternative(beanAttributes.isAlternative());
        return this;
    }

    public BeanAttributesConfigurator<T> addType(Type type) {
        Preconditions.checkArgumentNotNull(type);
        this.types.add(type);
        return this;
    }

    public BeanAttributesConfigurator<T> addType(TypeLiteral<?> typeLiteral) {
        Preconditions.checkArgumentNotNull(typeLiteral);
        this.types.add(typeLiteral.getType());
        return null;
    }

    public BeanAttributesConfigurator<T> addTypes(Type ... types) {
        Preconditions.checkArgumentNotNull(types);
        Collections.addAll(this.types, types);
        return this;
    }

    public BeanAttributesConfigurator<T> addTypes(Set<Type> types) {
        Preconditions.checkArgumentNotNull(types);
        this.types.addAll(types);
        return this;
    }

    public BeanAttributesConfigurator<T> addTransitiveTypeClosure(Type type) {
        Preconditions.checkArgumentNotNull(type);
        this.types.addAll(Beans.getLegalBeanTypes(new HierarchyDiscovery(type).getTypeClosure(), type, new Type[0]));
        return this;
    }

    public BeanAttributesConfigurator<T> types(Type ... types) {
        this.types.clear();
        return this.addTypes(types);
    }

    public BeanAttributesConfigurator<T> types(Set<Type> types) {
        this.types.clear();
        return this.addTypes(types);
    }

    public BeanAttributesConfigurator<T> scope(Class<? extends Annotation> scope) {
        Preconditions.checkArgumentNotNull(scope);
        this.scope = scope;
        return this;
    }

    public BeanAttributesConfigurator<T> addQualifier(Annotation qualifier) {
        Preconditions.checkArgumentNotNull(qualifier);
        this.removeDefaultQualifierIfNeeded(qualifier);
        this.qualifiers.add(qualifier);
        return this;
    }

    public BeanAttributesConfigurator<T> addQualifiers(Annotation ... qualifiers) {
        Preconditions.checkArgumentNotNull(qualifiers);
        for (Annotation annotation : qualifiers) {
            this.removeDefaultQualifierIfNeeded(annotation);
        }
        Collections.addAll(this.qualifiers, qualifiers);
        return this;
    }

    public BeanAttributesConfigurator<T> addQualifiers(Set<Annotation> qualifiers) {
        Preconditions.checkArgumentNotNull(qualifiers);
        for (Annotation annotation : qualifiers) {
            this.removeDefaultQualifierIfNeeded(annotation);
        }
        this.qualifiers.addAll(qualifiers);
        return this;
    }

    public BeanAttributesConfigurator<T> qualifiers(Annotation ... qualifiers) {
        this.qualifiers.clear();
        return this.addQualifiers(qualifiers);
    }

    public BeanAttributesConfigurator<T> qualifiers(Set<Annotation> qualifiers) {
        this.qualifiers.clear();
        return this.addQualifiers(qualifiers);
    }

    public BeanAttributesConfigurator<T> addStereotype(Class<? extends Annotation> stereotype) {
        Preconditions.checkArgumentNotNull(stereotype);
        this.stereotypes.add(stereotype);
        return this;
    }

    public BeanAttributesConfigurator<T> addStereotypes(Set<Class<? extends Annotation>> stereotypes) {
        Preconditions.checkArgumentNotNull(stereotypes);
        this.stereotypes.addAll(stereotypes);
        return this;
    }

    public BeanAttributesConfigurator<T> stereotypes(Set<Class<? extends Annotation>> stereotypes) {
        this.stereotypes.clear();
        return this.addStereotypes(stereotypes);
    }

    public BeanAttributesConfigurator<T> name(String name) {
        this.name = name;
        return this;
    }

    public BeanAttributesConfigurator<T> alternative(boolean alternative) {
        this.isAlternative = alternative;
        return this;
    }

    @Override
    public BeanAttributes<T> complete() {
        return new ImmutableBeanAttributes(ImmutableSet.copyOf(this.stereotypes), this.isAlternative, this.name, this.initQualifiers(this.qualifiers), ImmutableSet.copyOf(this.types), this.initScope());
    }

    private void removeDefaultQualifierIfNeeded(Annotation qualifier) {
        if (!qualifier.annotationType().equals(Named.class)) {
            this.qualifiers.remove(Default.Literal.INSTANCE);
        }
    }

    private Class<? extends Annotation> initScope() {
        if (this.scope != null) {
            return this.scope;
        }
        if (!this.stereotypes.isEmpty()) {
            MetaAnnotationStore metaAnnotationStore = (MetaAnnotationStore)this.beanManager.getServices().get(MetaAnnotationStore.class);
            HashSet<Annotation> possibleScopeTypes = new HashSet<Annotation>();
            for (Class<? extends Annotation> stereotype : this.stereotypes) {
                StereotypeModel<? extends Annotation> model = metaAnnotationStore.getStereotype(stereotype);
                if (model.isValid()) {
                    possibleScopeTypes.add(model.getDefaultScopeType());
                    continue;
                }
                throw BeanManagerLogger.LOG.notStereotype(stereotype);
            }
            if (possibleScopeTypes.size() == 1) {
                return ((Annotation)possibleScopeTypes.iterator().next()).annotationType();
            }
            throw BeanLogger.LOG.multipleScopesFoundFromStereotypes(BeanAttributesConfigurator.class.getSimpleName(), Formats.formatTypes(this.stereotypes, false), possibleScopeTypes, "");
        }
        return Dependent.class;
    }

    private Set<Annotation> initQualifiers(Set<Annotation> qualifiers) {
        if (qualifiers.isEmpty()) {
            return Bindings.DEFAULT_QUALIFIERS;
        }
        Set<Annotation> normalized = new HashSet<Annotation>(qualifiers);
        normalized.remove(Any.Literal.INSTANCE);
        normalized.remove(Default.Literal.INSTANCE);
        if (normalized.isEmpty()) {
            normalized = Bindings.DEFAULT_QUALIFIERS;
        } else {
            ImmutableSet.Builder<Object> builder = ImmutableSet.builder();
            if (normalized.size() == 1 && normalized.iterator().next().annotationType().equals(Named.class)) {
                builder.add(Default.Literal.INSTANCE);
            }
            builder.add(Any.Literal.INSTANCE);
            builder.addAll((Iterable<Object>)qualifiers);
            normalized = builder.build();
        }
        return normalized;
    }
}

