/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.ResourceAllocationException;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAJMSContext;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.jms.XATopicSession;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jms.JmsConnectionContext;
import org.jboss.resource.adapter.jms.JmsConnectionRequestInfo;
import org.jboss.resource.adapter.jms.JmsConnectionSession;
import org.jboss.resource.adapter.jms.JmsCred;
import org.jboss.resource.adapter.jms.JmsLocalTransaction;
import org.jboss.resource.adapter.jms.JmsManagedConnectionFactory;
import org.jboss.resource.adapter.jms.JmsMetaData;
import org.jboss.resource.adapter.jms.JmsSession;
import org.jboss.resource.adapter.jms.JmsXAResource;
import org.jboss.resource.adapter.jms.ReentrantLock;
import org.jboss.resource.adapter.jms.inflow.JmsActivation;
import org.jboss.resource.adapter.jms.util.SecurityActions;

public class JmsManagedConnection
implements ManagedConnection,
ExceptionListener {
    private static final Logger log = Logger.getLogger(JmsManagedConnection.class);
    private JmsManagedConnectionFactory mcf;
    private JmsConnectionRequestInfo info;
    private String user;
    private String pwd;
    private volatile boolean isSetUp;
    private volatile boolean isDestroyed;
    private ReentrantLock lock = new ReentrantLock(true);
    private Connection con = null;
    private Session session = null;
    private XASession xaSession = null;
    private XAResource xaResource = null;
    private boolean xaTransacted = false;
    private JMSContext context = null;
    private XAJMSContext xaContext = null;
    private Set<JmsSession> handles = Collections.synchronizedSet(new HashSet());
    private Vector<ConnectionEventListener> listeners = new Vector();

    public JmsManagedConnection(JmsManagedConnectionFactory mcf, ConnectionRequestInfo info, String user, String pwd) throws ResourceException {
        this.mcf = mcf;
        this.info = (JmsConnectionRequestInfo)info;
        this.user = user;
        this.pwd = pwd;
        try {
            this.setup();
        }
        catch (Throwable t) {
            try {
                this.destroy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (t instanceof ResourceException) {
                throw (ResourceException)t;
            }
            throw new ResourceException(t);
        }
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        JmsCred cred = JmsCred.getJmsCred(this.mcf, subject, info);
        if (this.user != null && !this.user.equals(cred.name)) {
            throw new javax.resource.spi.SecurityException("Password credentials not the same, reauthentication not allowed");
        }
        if (cred.name != null && this.user == null) {
            throw new javax.resource.spi.SecurityException("Password credentials not the same, reauthentication not allowed");
        }
        this.user = cred.name;
        if (this.isDestroyed) {
            throw new IllegalStateException("ManagedConnection already destroyed");
        }
        JmsSession handle = new JmsSession(this, (JmsConnectionRequestInfo)info);
        this.handles.add(handle);
        return handle;
    }

    private void destroyHandles() throws ResourceException {
        try {
            if (this.con != null) {
                this.con.stop();
            }
        }
        catch (Throwable t) {
            log.trace((Object)"Ignored error stopping connection", t);
        }
        Iterator<JmsSession> iter = this.handles.iterator();
        while (iter.hasNext()) {
            iter.next().destroy();
        }
        this.handles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() throws ResourceException {
        if (this.isDestroyed || this.con == null) {
            return;
        }
        JmsManagedConnection jmsManagedConnection = this;
        synchronized (jmsManagedConnection) {
            if (this.isDestroyed || this.con == null) {
                return;
            }
            try {
                this.con.setExceptionListener(null);
            }
            catch (JMSException e) {
                log.debug((Object)("Error unsetting the exception listener " + this), (Throwable)e);
            }
            this.destroyHandles();
            try {
                if (this.xaTransacted && this.xaContext != null) {
                    this.xaContext.close();
                }
                if (this.context != null) {
                    this.context.close();
                }
                try {
                    if (this.session != null) {
                        this.session.close();
                    }
                }
                catch (JMSException e) {
                    log.debug((Object)("Error closing session " + this), (Throwable)e);
                }
                try {
                    if (this.xaTransacted && this.xaSession != null) {
                        this.xaSession.close();
                    }
                }
                catch (JMSException e) {
                    log.debug((Object)("Error closing xaSession " + this), (Throwable)e);
                }
                this.con.close();
            }
            catch (Throwable e) {
                throw new ResourceException("Could not properly close the session and connection", e);
            }
            finally {
                this.isDestroyed = true;
            }
        }
    }

    public void cleanup() throws ResourceException {
        if (this.isDestroyed) {
            throw new IllegalStateException("ManagedConnection already destroyed");
        }
        this.destroyHandles();
        boolean isActive = false;
        if (this.lock.hasQueuedThreads()) {
            Collection<Thread> threads = this.lock.getQueuedThreads();
            for (Thread thread : threads) {
                Throwable t = new Throwable("Thread waiting for lock during cleanup");
                t.setStackTrace(thread.getStackTrace());
                log.warn((Object)t.getMessage(), t);
            }
            isActive = true;
        }
        if (this.lock.isLocked()) {
            Throwable t = new Throwable("Lock owned during cleanup");
            t.setStackTrace(this.lock.getOwner().getStackTrace());
            log.warn((Object)t.getMessage(), t);
            isActive = true;
        }
        if (isActive) {
            throw new ResourceException("Still active locks for " + this);
        }
    }

    public void associateConnection(Object obj) throws ResourceException {
        if (this.isDestroyed || !(obj instanceof JmsSession)) {
            throw new IllegalStateException("ManagedConnection in an illegal state");
        }
        JmsSession h = (JmsSession)obj;
        h.setManagedConnection(this);
        this.handles.add(h);
    }

    protected void lock() {
        this.lock.lock();
    }

    protected void tryLock() throws JMSException {
        int tryLock = this.mcf.getUseTryLock();
        if (tryLock <= 0) {
            this.lock();
            return;
        }
        try {
            if (!this.lock.tryLock(tryLock, TimeUnit.SECONDS)) {
                throw new ResourceAllocationException("Unable to obtain lock in " + tryLock + " seconds: " + this);
            }
        }
        catch (InterruptedException e) {
            throw new ResourceAllocationException("Interrupted attempting lock: " + this);
        }
    }

    protected void unlock() {
        if (this.lock.isLocked()) {
            this.lock.unlock();
        } else {
            log.warn((Object)"Owner is null");
            Throwable t = new Throwable("Thread trying to unlock");
            t.setStackTrace(Thread.currentThread().getStackTrace());
            log.warn((Object)t.getMessage(), t);
        }
    }

    public void addConnectionEventListener(ConnectionEventListener l) {
        this.listeners.addElement(l);
        if (log.isTraceEnabled()) {
            log.trace((Object)("ConnectionEvent listener added: " + l));
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener l) {
        this.listeners.removeElement(l);
    }

    public XAResource getXAResource() throws ResourceException {
        if (!this.xaTransacted) {
            return null;
        }
        if (this.xaResource == null) {
            this.xaResource = this.xaSession.getXAResource();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("XAResource=" + this.xaResource));
        }
        this.xaResource = new JmsXAResource(this, this.xaResource);
        return this.xaResource;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        JmsLocalTransaction tx = new JmsLocalTransaction(this);
        if (log.isTraceEnabled()) {
            log.trace((Object)("LocalTransaction=" + tx));
        }
        return tx;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        if (this.isDestroyed) {
            throw new IllegalStateException("ManagedConnection already destroyd");
        }
        return new JmsMetaData(this);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return null;
    }

    public void onException(JMSException exception) {
        if (this.isDestroyed) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Ignoring error on already destroyed connection " + this), (Throwable)exception);
            }
            return;
        }
        log.warn((Object)("Handling jms exception failure: " + this), (Throwable)exception);
        if (this.lock.isLocked() && Thread.currentThread().equals(this.lock.getOwner())) {
            this.unlock();
        }
        try {
            this.con.setExceptionListener(null);
        }
        catch (JMSException e) {
            log.debug((Object)"Unable to unset exception listener", (Throwable)e);
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 5, (Exception)((Object)exception));
        this.sendEvent(event);
    }

    protected Session getSession() {
        return this.session;
    }

    protected JMSContext getJMSContext() {
        return this.context;
    }

    protected void sendEvent(ConnectionEvent event) {
        int type = event.getId();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Sending connection event: " + type));
        }
        ConnectionEventListener[] list = this.listeners.toArray(new ConnectionEventListener[this.listeners.size()]);
        block7: for (int i = 0; i < list.length; ++i) {
            switch (type) {
                case 1: {
                    list[i].connectionClosed(event);
                    continue block7;
                }
                case 2: {
                    list[i].localTransactionStarted(event);
                    continue block7;
                }
                case 3: {
                    list[i].localTransactionCommitted(event);
                    continue block7;
                }
                case 4: {
                    list[i].localTransactionRolledback(event);
                    continue block7;
                }
                case 5: {
                    list[i].connectionErrorOccurred(event);
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Illegal eventType: " + type);
                }
            }
        }
    }

    protected void removeHandle(JmsSession handle) {
        this.handles.remove(handle);
    }

    protected ConnectionRequestInfo getInfo() {
        return this.info;
    }

    protected JmsManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    void start() throws JMSException {
        this.con.start();
    }

    void stop() throws JMSException {
        this.con.stop();
    }

    protected String getUserName() {
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setup() throws ResourceException {
        JmsManagedConnection jmsManagedConnection = this;
        synchronized (jmsManagedConnection) {
            if (this.isSetUp) {
                return;
            }
            boolean trace = log.isTraceEnabled();
            ClassLoader oldTCCL = SecurityActions.getThreadContextClassLoader();
            try {
                SecurityActions.setThreadContextClassLoader(JmsManagedConnection.class.getClassLoader());
                Context jndiContext = JmsActivation.convertStringToContext(this.mcf.getJndiParameters());
                boolean transacted = this.info.isTransacted();
                int ack = transacted ? 0 : this.info.getAcknowledgeMode();
                String connectionFactory = this.mcf.getConnectionFactory();
                if (connectionFactory == null) {
                    throw new IllegalStateException("No configured 'connectionFactory'.");
                }
                Object factory = jndiContext.lookup(connectionFactory);
                this.con = this.createConnection(factory, this.user, this.pwd, transacted, ack);
                if (this.con instanceof XAConnection && transacted) {
                    switch (this.mcf.getProperties().getType()) {
                        case 1: {
                            this.xaSession = ((XAQueueConnection)this.con).createXAQueueSession();
                            this.session = ((XAQueueSession)this.xaSession).getQueueSession();
                            break;
                        }
                        case 2: {
                            this.xaSession = ((XATopicConnection)this.con).createXATopicSession();
                            this.session = ((XATopicSession)this.xaSession).getTopicSession();
                            break;
                        }
                        default: {
                            this.xaSession = ((XAConnection)this.con).createXASession();
                            this.session = this.xaSession.getSession();
                        }
                    }
                    this.xaTransacted = true;
                } else {
                    switch (this.mcf.getProperties().getType()) {
                        case 1: {
                            this.session = ((QueueConnection)this.con).createQueueSession(transacted, ack);
                            break;
                        }
                        case 2: {
                            this.session = ((TopicConnection)this.con).createTopicSession(transacted, ack);
                            break;
                        }
                        default: {
                            this.session = this.con.createSession(transacted, ack);
                        }
                    }
                    if (trace) {
                        log.trace((Object)"Using a non-XA Connection.  It will not be able to participate in a Global UOW");
                    }
                }
                this.con.setExceptionListener((ExceptionListener)this);
                if (trace) {
                    log.trace((Object)("created connection: " + this.con));
                }
                log.debug((Object)("xaSession=" + this.xaSession + ", Session=" + this.session));
                log.debug((Object)("transacted=" + transacted + ", ack=" + ack));
                this.isSetUp = true;
            }
            catch (JMSException | NamingException e) {
                throw new ResourceException("Unable to setup connection", e);
            }
            finally {
                SecurityActions.setThreadContextClassLoader(oldTCCL);
            }
        }
    }

    public Connection createConnection(Object factory, String username, String password, boolean transacted, int ack) throws JMSException {
        if (factory == null) {
            throw new IllegalArgumentException("factory is null");
        }
        log.debug((Object)("using connection factory: " + factory));
        log.debug((Object)("using username/password: " + String.valueOf(username) + "/-- not shown --"));
        XASession connection = null;
        if (factory instanceof XAConnectionFactory) {
            XAConnectionFactory xaConnFactory = (XAConnectionFactory)factory;
            if (username != null) {
                switch (this.mcf.getProperties().getType()) {
                    case 1: {
                        XAQueueConnection realConnection = ((XAQueueConnectionFactory)xaConnFactory).createXAQueueConnection(username, password);
                        this.context = null;
                        connection = new JmsConnectionSession((Connection)realConnection, this.createSession((Connection)realConnection, transacted, ack));
                        break;
                    }
                    case 2: {
                        XATopicConnection realConnection = ((XATopicConnectionFactory)xaConnFactory).createXATopicConnection(username, password);
                        this.context = null;
                        connection = new JmsConnectionSession((Connection)realConnection, this.createSession((Connection)realConnection, transacted, ack));
                        break;
                    }
                    case 0: {
                        XAConnection realConnection = xaConnFactory.createXAConnection(username, password);
                        if (this.isJMS_2_0(xaConnFactory)) {
                            this.xaContext = xaConnFactory.createXAContext(username, password);
                            this.context = this.xaContext.getContext();
                        } else {
                            this.context = null;
                            this.xaContext = null;
                        }
                        connection = new JmsConnectionSession((Connection)realConnection, this.createSession((Connection)realConnection, transacted, ack));
                        break;
                    }
                    case 3: {
                        try {
                            this.xaContext = xaConnFactory.createXAContext(username, password);
                            if (this.info.getClientID() != null && !this.info.getClientID().equals(this.xaContext.getClientID())) {
                                this.xaContext.setClientID(this.info.getClientID());
                            }
                            this.context = this.xaContext.getContext();
                            connection = new JmsConnectionContext(this.context);
                            break;
                        }
                        catch (Exception e) {
                            log.fatal((Object)("The JMS provider does not support the JMS 2.0 XAJMSContext interface: " + e.getMessage()), (Throwable)e);
                            throw new JMSException("The JMS provider does not support the JMS 2.0 XAJMSContext interface");
                        }
                    }
                }
            } else {
                switch (this.mcf.getProperties().getType()) {
                    case 1: {
                        XAQueueConnection realConnection = ((XAQueueConnectionFactory)xaConnFactory).createXAQueueConnection();
                        this.context = null;
                        connection = new JmsConnectionSession((Connection)realConnection, this.createSession((Connection)realConnection, transacted, ack));
                        break;
                    }
                    case 2: {
                        XATopicConnection realConnection = ((XATopicConnectionFactory)xaConnFactory).createXATopicConnection();
                        this.context = null;
                        connection = new JmsConnectionSession((Connection)realConnection, this.createSession((Connection)realConnection, transacted, ack));
                        break;
                    }
                    case 0: {
                        XAConnection realConnection = xaConnFactory.createXAConnection();
                        if (this.isJMS_2_0(xaConnFactory)) {
                            this.xaContext = xaConnFactory.createXAContext();
                            this.context = this.xaContext.getContext();
                        } else {
                            this.xaContext = null;
                            this.context = null;
                        }
                        connection = new JmsConnectionSession((Connection)realConnection, this.createSession((Connection)realConnection, transacted, ack));
                        break;
                    }
                    case 3: {
                        try {
                            this.xaContext = xaConnFactory.createXAContext();
                            if (this.info.getClientID() != null && !this.info.getClientID().equals(this.xaContext.getClientID())) {
                                this.xaContext.setClientID(this.info.getClientID());
                            }
                            this.context = this.xaContext.getContext();
                            connection = new JmsConnectionContext(this.context);
                            break;
                        }
                        catch (Exception e) {
                            log.fatal((Object)("The JMS provider does not support the JMS 2.0 XAJMSContext interface: " + e.getMessage()), (Throwable)e);
                            throw new JMSException("The JMS provider does not support the JMS 2.0 XAJMSContext interface");
                        }
                    }
                }
            }
            log.debug((Object)("created XAConnection: " + connection));
        } else if (factory instanceof ConnectionFactory) {
            ConnectionFactory nonXAConnFactory = (ConnectionFactory)factory;
            if (username != null) {
                switch (this.mcf.getProperties().getType()) {
                    case 1: {
                        QueueConnection realConnection = ((QueueConnectionFactory)nonXAConnFactory).createQueueConnection(username, password);
                        this.context = null;
                        connection = new JmsConnectionSession((Connection)realConnection, this.createSession((Connection)realConnection, transacted, ack));
                        break;
                    }
                    case 2: {
                        TopicConnection realConnection = ((TopicConnectionFactory)nonXAConnFactory).createTopicConnection(username, password);
                        this.context = null;
                        connection = new JmsConnectionSession((Connection)realConnection, this.createSession((Connection)realConnection, transacted, ack));
                        break;
                    }
                    case 0: {
                        Connection realConnection = nonXAConnFactory.createConnection(username, password);
                        this.context = this.isJMS_2_0(nonXAConnFactory) ? nonXAConnFactory.createContext(username, password) : null;
                        connection = new JmsConnectionSession(realConnection, this.createSession(realConnection, transacted, ack));
                        break;
                    }
                    case 3: {
                        try {
                            this.context = nonXAConnFactory.createContext(username, password);
                            if (this.info.getClientID() != null && !this.info.getClientID().equals(this.context.getClientID())) {
                                this.context.setClientID(this.info.getClientID());
                            }
                            connection = new JmsConnectionContext(this.context);
                            break;
                        }
                        catch (Exception e) {
                            log.fatal((Object)("The JMS provider does not support the JMS 2.0 JMSContext interface: " + e.getMessage()), (Throwable)e);
                            throw new JMSException("The JMS provider does not support the JMS 2.0 JMSContext interface");
                        }
                    }
                }
            } else {
                switch (this.mcf.getProperties().getType()) {
                    case 1: {
                        QueueConnection realConnection = ((QueueConnectionFactory)nonXAConnFactory).createQueueConnection();
                        this.context = null;
                        connection = new JmsConnectionSession((Connection)realConnection, this.createSession((Connection)realConnection, transacted, ack));
                        break;
                    }
                    case 2: {
                        TopicConnection realConnection = ((TopicConnectionFactory)nonXAConnFactory).createTopicConnection();
                        this.context = null;
                        connection = new JmsConnectionSession((Connection)realConnection, this.createSession((Connection)realConnection, transacted, ack));
                        break;
                    }
                    case 0: {
                        Connection realConnection = nonXAConnFactory.createConnection();
                        this.context = this.isJMS_2_0(nonXAConnFactory) ? nonXAConnFactory.createContext() : null;
                        connection = new JmsConnectionSession(realConnection, this.createSession(realConnection, transacted, ack));
                        break;
                    }
                    case 3: {
                        try {
                            this.context = nonXAConnFactory.createContext();
                            if (this.info.getClientID() != null && !this.info.getClientID().equals(this.context.getClientID())) {
                                this.context.setClientID(this.info.getClientID());
                            }
                            connection = new JmsConnectionContext(this.context);
                            break;
                        }
                        catch (Exception e) {
                            log.fatal((Object)("The JMS provider does not support the JMS 2.0 JMSContext interface: " + e.getMessage()), (Throwable)e);
                            throw new JMSException("The JMS provider does not support the JMS 2.0 JMSContext interface");
                        }
                    }
                }
            }
            log.debug((Object)("created " + this.mcf.getProperties().getSessionDefaultType() + " connection: " + connection));
        } else {
            throw new IllegalArgumentException("factory is invalid: " + factory);
        }
        return connection;
    }

    private boolean hasMethod(Object object, String method) {
        try {
            object.getClass().getMethod(method, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            return false;
        }
        return true;
    }

    private Session createSession(Connection connection, boolean xaTransacted, int ack) throws JMSException {
        Session internalSession;
        if (this.info.getClientID() != null && !this.info.getClientID().equals(connection.getClientID())) {
            connection.setClientID(this.info.getClientID());
        }
        if (this.isJMS_2_0(connection)) {
            internalSession = connection.createSession();
            log.debug((Object)("Session " + internalSession + " created with createSession()"));
        } else {
            internalSession = connection.createSession(xaTransacted, ack);
            log.debug((Object)("Session " + internalSession + " created with createSession(" + xaTransacted + ", " + ack + ")"));
        }
        return internalSession;
    }

    private boolean isJMS_2_0(Connection connection) {
        return this.mcf.isJMS20() != false && this.hasMethod(connection, "createSession");
    }

    private boolean isJMS_2_0(ConnectionFactory connectionFactory) {
        return this.mcf.isJMS20() != false && this.hasMethod(connectionFactory, "createContext");
    }

    private boolean isJMS_2_0(XAConnectionFactory connectionFactory) {
        return this.mcf.isJMS20() != false && this.hasMethod(connectionFactory, "createXAContext");
    }

    public String toString() {
        return "JmsManagedConnection{mcf=" + this.mcf + ", info=" + this.info + ", user=" + this.user + ", pwd=****, isSetUp=" + this.isSetUp + ", isDestroyed=" + this.isDestroyed + ", lock=" + this.lock + ", con=" + this.con + ", session=" + (this.session != null ? this.session.getClass() + "@" + this.session.hashCode() : "null") + ", xaSession=" + (this.xaSession != null ? this.xaSession.getClass() + "@" + this.xaSession.hashCode() : "null") + ", xaResource=" + this.xaResource + ", xaTransacted=" + this.xaTransacted + ", context=" + this.context + ", xaContext=" + this.xaContext + '}';
    }
}

