/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.time;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.time.Month;
import java.time.YearMonth;
import java.util.OptionalInt;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.time.TimeExternalizerProvider;

public class YearMonthExternalizer
implements Externalizer<YearMonth> {
    public void writeObject(ObjectOutput output, YearMonth value) throws IOException {
        output.writeInt(value.getYear());
        TimeExternalizerProvider.MONTH.cast(Month.class).writeObject(output, (Object)value.getMonth());
    }

    public YearMonth readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int year = input.readInt();
        Month month = (Month)TimeExternalizerProvider.MONTH.cast(Month.class).readObject(input);
        return YearMonth.of(year, month);
    }

    public Class<YearMonth> getTargetClass() {
        return YearMonth.class;
    }

    public OptionalInt size(YearMonth value) {
        return OptionalInt.of(4 + TimeExternalizerProvider.MONTH.size(value.getMonth()).getAsInt());
    }
}

