/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.protocol.Errors;

@InterfaceStability.Evolving
public class AlterConsumerGroupOffsetsResult {
    private final KafkaFuture<Map<TopicPartition, Errors>> future;

    AlterConsumerGroupOffsetsResult(KafkaFuture<Map<TopicPartition, Errors>> future) {
        this.future = future;
    }

    public KafkaFuture<Void> partitionResult(TopicPartition partition) {
        KafkaFutureImpl<Void> result = new KafkaFutureImpl<Void>();
        this.future.whenComplete((topicPartitions, throwable) -> {
            if (throwable != null) {
                result.completeExceptionally((Throwable)throwable);
            } else if (!topicPartitions.containsKey(partition)) {
                result.completeExceptionally(new IllegalArgumentException("Alter offset for partition \"" + partition + "\" was not attempted"));
            } else {
                Errors error = (Errors)((Object)((Object)topicPartitions.get(partition)));
                if (error == Errors.NONE) {
                    result.complete(null);
                } else {
                    result.completeExceptionally(error.exception());
                }
            }
        });
        return result;
    }

    public KafkaFuture<Void> all() {
        return this.future.thenApply(topicPartitionErrorsMap -> {
            List partitionsFailed = topicPartitionErrorsMap.entrySet().stream().filter(e -> e.getValue() != Errors.NONE).map(Map.Entry::getKey).collect(Collectors.toList());
            for (Errors error : topicPartitionErrorsMap.values()) {
                if (error == Errors.NONE) continue;
                throw error.exception("Failed altering consumer group offsets for the following partitions: " + partitionsFailed);
            }
            return null;
        });
    }
}

