/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.IntSet;
import org.infinispan.persistence.sifs.Compactor;
import org.infinispan.persistence.sifs.EntryInfo;
import org.infinispan.persistence.sifs.EntryPosition;
import org.infinispan.persistence.sifs.EntryRecord;
import org.infinispan.persistence.sifs.FileProvider;
import org.infinispan.persistence.sifs.IndexNode;
import org.infinispan.persistence.sifs.IndexRequest;
import org.infinispan.persistence.sifs.Log;
import org.infinispan.persistence.sifs.TemporaryTable;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.concurrent.NonBlockingManager;
import org.infinispan.util.logging.LogFactory;

class Index {
    private static final Log log = LogFactory.getLog(Index.class, Log.class);
    private static final int GRACEFULLY = 1361759985;
    private static final int DIRTY = -787319028;
    private static final int INDEX_FILE_HEADER_SIZE = 34;
    private final NonBlockingManager nonBlockingManager;
    private final FileProvider fileProvider;
    private final Path indexDir;
    private final Compactor compactor;
    private final int minNodeSize;
    private final int maxNodeSize;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Segment[] segments;
    private final TimeService timeService;
    private final FlowableProcessor<IndexRequest>[] flowableProcessors;

    public Index(NonBlockingManager nonBlockingManager, FileProvider fileProvider, Path indexDir, int segments, int minNodeSize, int maxNodeSize, TemporaryTable temporaryTable, Compactor compactor, TimeService timeService) throws IOException {
        this.nonBlockingManager = nonBlockingManager;
        this.fileProvider = fileProvider;
        this.compactor = compactor;
        this.timeService = timeService;
        this.indexDir = indexDir;
        this.minNodeSize = minNodeSize;
        this.maxNodeSize = maxNodeSize;
        indexDir.toFile().mkdirs();
        this.segments = new Segment[segments];
        this.flowableProcessors = new FlowableProcessor[segments];
        for (int i = 0; i < segments; ++i) {
            Segment segment;
            UnicastProcessor flowableProcessor = UnicastProcessor.create();
            this.segments[i] = segment = new Segment(i, temporaryTable);
            this.flowableProcessors[i] = flowableProcessor.toSerialized();
        }
    }

    public boolean isLoaded() {
        for (Segment segment : this.segments) {
            if (segment.loaded) continue;
            return false;
        }
        return true;
    }

    public EntryRecord getRecord(Object key, byte[] serializedKey) throws IOException {
        return this.getRecord(key, serializedKey, IndexNode.ReadOperation.GET_RECORD);
    }

    public EntryRecord getRecordEvenIfExpired(Object key, byte[] serializedKey) throws IOException {
        return this.getRecord(key, serializedKey, IndexNode.ReadOperation.GET_EXPIRED_RECORD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntryRecord getRecord(Object key, byte[] serializedKey, IndexNode.ReadOperation readOperation) throws IOException {
        int segment = (key.hashCode() & Integer.MAX_VALUE) % this.segments.length;
        this.lock.readLock().lock();
        try {
            EntryRecord entryRecord = (EntryRecord)IndexNode.applyOnLeaf(this.segments[segment], serializedKey, this.segments[segment].rootReadLock(), readOperation);
            return entryRecord;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryPosition getPosition(Object key, byte[] serializedKey) throws IOException {
        int segment = (key.hashCode() & Integer.MAX_VALUE) % this.segments.length;
        this.lock.readLock().lock();
        try {
            EntryPosition entryPosition = (EntryPosition)IndexNode.applyOnLeaf(this.segments[segment], serializedKey, this.segments[segment].rootReadLock(), IndexNode.ReadOperation.GET_POSITION);
            return entryPosition;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryInfo getInfo(Object key, byte[] serializedKey) throws IOException {
        int segment = (key.hashCode() & Integer.MAX_VALUE) % this.segments.length;
        this.lock.readLock().lock();
        try {
            EntryInfo entryInfo = (EntryInfo)IndexNode.applyOnLeaf(this.segments[segment], serializedKey, this.segments[segment].rootReadLock(), IndexNode.ReadOperation.GET_INFO);
            return entryInfo;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Void> clear() {
        this.lock.writeLock().lock();
        try {
            AggregateCompletionStage<Void> stage = CompletionStages.aggregateCompletionStage();
            for (FlowableProcessor<IndexRequest> processor : this.flowableProcessors) {
                IndexRequest clearRequest = IndexRequest.clearRequest();
                processor.onNext((Object)clearRequest);
                stage.dependsOn(clearRequest);
            }
            CompletionStage<Void> completionStage = stage.freeze();
            return completionStage;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public CompletionStage<Object> handleRequest(IndexRequest indexRequest) {
        int processor = (indexRequest.getKey().hashCode() & Integer.MAX_VALUE) % this.segments.length;
        this.flowableProcessors[processor].onNext((Object)indexRequest);
        return indexRequest;
    }

    public void deleteFileAsync(int fileId) {
        AtomicInteger count = new AtomicInteger(this.flowableProcessors.length);
        IndexRequest deleteFile = IndexRequest.syncRequest(() -> {
            if (count.decrementAndGet() == 0) {
                this.fileProvider.deleteFile(fileId);
                log.tracef("Deleted file %s", fileId);
                this.compactor.releaseStats(fileId);
            }
        });
        for (FlowableProcessor<IndexRequest> flowableProcessor : this.flowableProcessors) {
            flowableProcessor.onNext((Object)deleteFile);
        }
    }

    public CompletionStage<Void> stop() throws InterruptedException {
        for (FlowableProcessor<IndexRequest> flowableProcessor : this.flowableProcessors) {
            flowableProcessor.onComplete();
        }
        AggregateCompletionStage<Void> aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
        for (Segment segment : this.segments) {
            aggregateCompletionStage.dependsOn(segment);
        }
        return aggregateCompletionStage.freeze();
    }

    public CompletionStage<Long> size() {
        AtomicLong size = new AtomicLong();
        AggregateCompletionStage<AtomicLong> aggregateCompletionStage = CompletionStages.aggregateCompletionStage(size);
        for (FlowableProcessor<IndexRequest> flowableProcessor : this.flowableProcessors) {
            IndexRequest request = IndexRequest.sizeRequest();
            flowableProcessor.onNext((Object)request);
            aggregateCompletionStage.dependsOn(request.thenAccept(count -> size.addAndGet((Long)count)));
        }
        return aggregateCompletionStage.freeze().thenApply(AtomicLong::get);
    }

    public long approximateSize() {
        long size = 0L;
        for (Segment segment : this.segments) {
            size += segment.size.get();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxSeqId() throws IOException {
        long maxSeqId = 0L;
        this.lock.readLock().lock();
        try {
            for (Segment seg : this.segments) {
                maxSeqId = Math.max(maxSeqId, IndexNode.calculateMaxSeqId(seg, seg.rootReadLock()));
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return maxSeqId;
    }

    public void start(Executor executor) {
        for (int i = 0; i < this.segments.length; ++i) {
            Segment segment = this.segments[i];
            this.flowableProcessors[i].observeOn(Schedulers.from((Executor)executor)).subscribe((Consumer)segment, segment::completeExceptionally, (Action)segment);
        }
    }

    <V> Flowable<EntryRecord> publish(IntSet cacheSegments, boolean loadValues) {
        return Flowable.fromArray((Object[])this.segments).concatMap(segment -> ((Segment)segment).root.publish(cacheSegments, loadValues));
    }

    static class IndexSpace {
        protected long offset;
        protected short length;

        IndexSpace(long offset, short length) {
            this.offset = offset;
            this.length = length;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IndexSpace)) {
                return false;
            }
            IndexSpace innerNode = (IndexSpace)o;
            return this.length == innerNode.length && this.offset == innerNode.offset;
        }

        public int hashCode() {
            int result = (int)(this.offset ^ this.offset >>> 32);
            result = 31 * result + this.length;
            return result;
        }

        public String toString() {
            return String.format("[%d-%d(%d)]", this.offset, this.offset + (long)this.length, this.length);
        }
    }

    class Segment
    extends CompletableFuture<Void>
    implements Consumer<IndexRequest>,
    Action {
        private final TemporaryTable temporaryTable;
        private final TreeMap<Short, List<IndexSpace>> freeBlocks = new TreeMap();
        private final ReadWriteLock rootLock = new ReentrantReadWriteLock();
        private final boolean loaded;
        private final FileChannel indexFile;
        private long indexFileSize;
        private final AtomicLong size = new AtomicLong();
        private volatile IndexNode root;

        private Segment(int id, TemporaryTable temporaryTable) throws IOException {
            this.temporaryTable = temporaryTable;
            int segmentMax = temporaryTable.getSegmentMax();
            File indexFileFile = new File(Index.this.indexDir.toFile(), "index." + id);
            this.indexFile = new RandomAccessFile(indexFileFile, "rw").getChannel();
            this.indexFile.position(0L);
            ByteBuffer buffer = ByteBuffer.allocate(34);
            int gracefulValue = -1;
            int segmentValue = -1;
            if (this.indexFile.size() >= 34L && this.read(this.indexFile, buffer) && (gracefulValue = buffer.getInt(0)) == 1361759985 && (segmentValue = buffer.getInt(4)) == segmentMax) {
                long rootOffset = buffer.getLong(8);
                short rootOccupied = buffer.getShort(16);
                long freeBlocksOffset = buffer.getLong(18);
                this.size.set(buffer.getLong(26));
                this.root = new IndexNode(this, rootOffset, rootOccupied);
                this.loadFreeBlocks(freeBlocksOffset);
                this.indexFileSize = freeBlocksOffset;
                this.loaded = true;
            } else {
                log.tracef("Index %d is not valid must rebuild, gracefulValue=%s segments=%d", id, gracefulValue, segmentValue);
                this.indexFile.truncate(0L);
                this.root = IndexNode.emptyWithLeaves(this);
                this.loaded = false;
                this.indexFileSize = 34L;
            }
            buffer.putInt(0, -787319028);
            buffer.position(0);
            buffer.limit(4);
            this.indexFile.position(0L);
            this.write(this.indexFile, buffer);
        }

        private void write(FileChannel indexFile, ByteBuffer buffer) throws IOException {
            do {
                int written;
                if ((written = indexFile.write(buffer)) >= 0) continue;
                throw new IllegalStateException("Cannot write to index file!");
            } while (buffer.position() < buffer.limit());
        }

        private boolean read(FileChannel indexFile, ByteBuffer buffer) throws IOException {
            do {
                int read;
                if ((read = indexFile.read(buffer)) >= 0) continue;
                return false;
            } while (buffer.position() < buffer.limit());
            return true;
        }

        public void accept(final IndexRequest request) throws Throwable {
            IndexNode.OverwriteHook overwriteHook;
            IndexNode.RecordChange recordChange;
            if (log.isTraceEnabled()) {
                log.trace("Indexing " + request);
            }
            switch (request.getType()) {
                case CLEAR: {
                    this.root = IndexNode.emptyWithLeaves(this);
                    this.indexFile.truncate(0L);
                    this.indexFileSize = 34L;
                    this.freeBlocks.clear();
                    this.size.set(0L);
                    Index.this.nonBlockingManager.complete(request, null);
                    return;
                }
                case SYNC_REQUEST: {
                    Runnable runnable = (Runnable)request.getKey();
                    runnable.run();
                    Index.this.nonBlockingManager.complete(request, null);
                    return;
                }
                case MOVED: {
                    recordChange = IndexNode.RecordChange.MOVE;
                    overwriteHook = new IndexNode.OverwriteHook(){

                        @Override
                        public boolean check(int oldFile, int oldOffset) {
                            return (long)oldFile == request.getPrevFile() && oldOffset == request.getPrevOffset();
                        }

                        @Override
                        public void setOverwritten(boolean overwritten, int prevFile, int prevOffset) {
                            if (overwritten && request.getOffset() < 0 && request.getPrevOffset() >= 0) {
                                Segment.this.size.decrementAndGet();
                            }
                        }
                    };
                    break;
                }
                case UPDATE: {
                    recordChange = IndexNode.RecordChange.INCREASE;
                    overwriteHook = (overwritten, prevFile, prevOffset) -> {
                        Index.this.nonBlockingManager.complete(request, overwritten);
                        if (request.getOffset() >= 0 && prevOffset < 0) {
                            this.size.incrementAndGet();
                        } else if (request.getOffset() < 0 && prevOffset >= 0) {
                            this.size.decrementAndGet();
                        }
                    };
                    break;
                }
                case DROPPED: {
                    recordChange = IndexNode.RecordChange.DECREASE;
                    overwriteHook = (overwritten, prevFile, prevOffset) -> {
                        if (request.getPrevFile() == (long)prevFile && request.getPrevOffset() == prevOffset) {
                            this.size.decrementAndGet();
                        }
                    };
                    break;
                }
                case FOUND_OLD: {
                    recordChange = IndexNode.RecordChange.INCREASE_FOR_OLD;
                    overwriteHook = IndexNode.NOOP_HOOK;
                    break;
                }
                case SIZE: {
                    Index.this.nonBlockingManager.complete(request, this.size.get());
                    return;
                }
                default: {
                    throw new IllegalArgumentException(request.toString());
                }
            }
            try {
                IndexNode.setPosition(this.root, request.getSegment(), request.getSerializedKey(), request.getFile(), request.getOffset(), request.getSize(), overwriteHook, recordChange);
            }
            catch (IllegalStateException e) {
                request.completeExceptionally(e);
            }
            this.temporaryTable.removeConditionally(request.getSegment(), request.getKey(), request.getFile(), request.getOffset());
            if (request.getType() != IndexRequest.Type.UPDATE) {
                Index.this.nonBlockingManager.complete(request, null);
            }
        }

        public void run() throws IOException {
            IndexSpace rootSpace = this.allocateIndexSpace(this.root.length());
            this.root.store(rootSpace);
            this.indexFile.position(this.indexFileSize);
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.putInt(0, this.freeBlocks.size());
            this.write(this.indexFile, buffer);
            for (Map.Entry<Short, List<IndexSpace>> entry : this.freeBlocks.entrySet()) {
                List<IndexSpace> list = entry.getValue();
                int requiredSize = 8 + list.size() * 10;
                buffer = buffer.capacity() < requiredSize ? ByteBuffer.allocate(requiredSize) : buffer;
                buffer.position(0);
                buffer.limit(requiredSize);
                buffer.putInt(entry.getKey().shortValue());
                buffer.putInt(list.size());
                for (IndexSpace space : list) {
                    buffer.putLong(space.offset);
                    buffer.putShort(space.length);
                }
                buffer.flip();
                this.write(this.indexFile, buffer);
            }
            int headerWithoutMagic = 26;
            buffer = buffer.capacity() < headerWithoutMagic ? ByteBuffer.allocate(headerWithoutMagic) : buffer;
            buffer.position(0);
            buffer.limit(headerWithoutMagic);
            buffer.putLong(0, rootSpace.offset);
            buffer.putShort(8, rootSpace.length);
            buffer.putLong(10, this.indexFileSize);
            buffer.putLong(18, this.size.get());
            this.indexFile.position(8L);
            this.write(this.indexFile, buffer);
            buffer.position(0);
            buffer.limit(8);
            buffer.putInt(0, 1361759985);
            buffer.putInt(4, this.temporaryTable.getSegmentMax());
            this.indexFile.position(0L);
            this.write(this.indexFile, buffer);
            this.complete(null);
        }

        private void loadFreeBlocks(long freeBlocksOffset) throws IOException {
            this.indexFile.position(freeBlocksOffset);
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.limit(4);
            if (!this.read(this.indexFile, buffer)) {
                throw new IOException("Cannot read free blocks lists!");
            }
            int numLists = buffer.getInt(0);
            for (int i = 0; i < numLists; ++i) {
                buffer.position(0);
                buffer.limit(8);
                if (!this.read(this.indexFile, buffer)) {
                    throw new IOException("Cannot read free blocks lists!");
                }
                int blockLength = buffer.getInt(0);
                assert (blockLength <= Short.MAX_VALUE);
                int listSize = buffer.getInt(4);
                int requiredSize = 10 * listSize;
                buffer = buffer.capacity() < requiredSize ? ByteBuffer.allocate(requiredSize) : buffer;
                buffer.position(0);
                buffer.limit(requiredSize);
                if (!this.read(this.indexFile, buffer)) {
                    throw new IOException("Cannot read free blocks lists!");
                }
                buffer.flip();
                ArrayList<IndexSpace> list = new ArrayList<IndexSpace>(listSize);
                for (int j = 0; j < listSize; ++j) {
                    list.add(new IndexSpace(buffer.getLong(), buffer.getShort()));
                }
                this.freeBlocks.put((short)blockLength, list);
            }
        }

        public FileChannel getIndexFile() {
            return this.indexFile;
        }

        public FileProvider getFileProvider() {
            return Index.this.fileProvider;
        }

        public Compactor getCompactor() {
            return Index.this.compactor;
        }

        public IndexNode getRoot() {
            return this.root;
        }

        public void setRoot(IndexNode root) {
            this.rootLock.writeLock().lock();
            this.root = root;
            this.rootLock.writeLock().unlock();
        }

        public int getMaxNodeSize() {
            return Index.this.maxNodeSize;
        }

        public int getMinNodeSize() {
            return Index.this.minNodeSize;
        }

        IndexSpace allocateIndexSpace(short length) {
            Map.Entry<Short, List<IndexSpace>> entry = this.freeBlocks.ceilingEntry(length);
            if (entry == null || entry.getValue().isEmpty()) {
                long oldSize = this.indexFileSize;
                this.indexFileSize += (long)length;
                return new IndexSpace(oldSize, length);
            }
            return entry.getValue().remove(entry.getValue().size() - 1);
        }

        void freeIndexSpace(long offset, short length) {
            if (length <= 0) {
                throw new IllegalArgumentException("Offset=" + offset + ", length=" + length);
            }
            if (offset + (long)length < this.indexFileSize) {
                this.freeBlocks.computeIfAbsent(length, k -> new ArrayList()).add(new IndexSpace(offset, length));
            } else {
                this.indexFileSize -= (long)length;
                try {
                    this.indexFile.truncate(this.indexFileSize);
                }
                catch (IOException e) {
                    log.cannotTruncateIndex(e);
                }
            }
        }

        Lock rootReadLock() {
            return this.rootLock.readLock();
        }

        public TimeService getTimeService() {
            return Index.this.timeService;
        }
    }
}

