/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.TpHeader;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

@MBean(description="Blocks all multicast threads when closed")
public class BARRIER
extends Protocol {
    @Property(description="Max time barrier can be closed. Default is 60000 ms")
    protected long max_close_time = 60000L;
    @Property(description="Max time (in ms) to wait until the threads which passed the barrier before it was closed have completed. If this time elapses, an exception will be thrown and state transfer will fail. 0 = wait forever")
    protected long flush_timeout = 5000L;
    protected final Lock lock = new ReentrantLock();
    protected final AtomicBoolean barrier_closed = new AtomicBoolean(false);
    protected Condition no_pending_threads = this.lock.newCondition();
    protected Map<Thread, Object> in_flight_threads = Util.createConcurrentMap();
    protected volatile Future<?> barrier_opener_future;
    protected TimeScheduler timer;
    protected Address local_addr;
    protected final Set<Address> holes = new HashSet<Address>();
    protected final Map<Address, Message> mcast_queue = new ConcurrentHashMap<Address, Message>();
    protected final Map<Address, Message> ucast_queue = new ConcurrentHashMap<Address, Message>();
    protected TP transport;
    protected static final Object NULL = new Object();

    @ManagedAttribute(description="Shows whether the barrier closed")
    public boolean isClosed() {
        return this.barrier_closed.get();
    }

    @ManagedAttribute(description="Lists the members whose unicast messages are let through")
    public String getHoles() {
        return this.holes.toString();
    }

    public int getNumberOfInFlightThreads() {
        return this.in_flight_threads.size();
    }

    @ManagedAttribute
    public int getInFlightThreadsCount() {
        return this.getNumberOfInFlightThreads();
    }

    @ManagedAttribute
    public boolean isOpenerScheduled() {
        return this.barrier_opener_future != null && !this.barrier_opener_future.isDone() && !this.barrier_opener_future.isCancelled();
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.transport = this.getTransport();
        this.timer = this.transport.getTimer();
    }

    @Override
    public void stop() {
        super.stop();
        this.openBarrier();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.openBarrier();
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 76: {
                try {
                    this.closeBarrier();
                }
                catch (TimeoutException e) {
                    throw new RuntimeException(e);
                }
                return null;
            }
            case 77: {
                this.openBarrier();
                return null;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 106: {
                Address mbr = (Address)evt.getArg();
                this.holes.add(mbr);
                return null;
            }
            case 107: {
                Address mbr = (Address)evt.getArg();
                this.holes.remove(mbr);
                return null;
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 76: {
                try {
                    this.closeBarrier();
                    return null;
                }
                catch (TimeoutException e) {
                    throw new RuntimeException(e);
                }
            }
            case 77: {
                this.openBarrier();
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Message msg) {
        if (msg.isFlagSet(Message.Flag.SKIP_BARRIER) || msg.getDest() != null && (msg.isFlagSet(Message.Flag.OOB) && msg.isFlagSet(Message.Flag.INTERNAL) || this.holes.contains(msg.getSrc()))) {
            return this.up_prot.up(msg);
        }
        if (this.barrier_closed.get()) {
            Map<Address, Message> map = msg.getDest() == null ? this.mcast_queue : this.ucast_queue;
            map.put(msg.getSrc(), msg);
            return null;
        }
        Thread current_thread = Thread.currentThread();
        this.in_flight_threads.put(current_thread, NULL);
        try {
            Object object = this.up_prot.up(msg);
            return object;
        }
        finally {
            this.unblock(current_thread);
        }
    }

    @Override
    public void up(MessageBatch batch) {
        if (batch.dest() != null && batch.mode() == MessageBatch.Mode.OOB && batch.mode() == MessageBatch.Mode.INTERNAL || this.holes.contains(batch.sender())) {
            this.up_prot.up(batch);
            return;
        }
        if (this.barrier_closed.get()) {
            Map<Address, Message> map = batch.dest() == null ? this.mcast_queue : this.ucast_queue;
            map.put(batch.sender(), batch.last().putHeader(this.transport.getId(), new TpHeader(batch.clusterName())));
            return;
        }
        Thread current_thread = Thread.currentThread();
        this.in_flight_threads.put(current_thread, NULL);
        try {
            this.up_prot.up(batch);
        }
        finally {
            this.unblock(current_thread);
        }
    }

    protected void unblock(Thread current_thread) {
        if (this.in_flight_threads.remove(current_thread) == NULL && this.in_flight_threads.isEmpty()) {
            this.lock.lock();
            try {
                this.no_pending_threads.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeBarrier() throws TimeoutException {
        if (!this.barrier_closed.compareAndSet(false, true)) {
            return;
        }
        long target_time = 0L;
        long wait_time = 0L;
        long start = System.currentTimeMillis();
        this.in_flight_threads.remove(Thread.currentThread());
        this.lock.lock();
        try {
            while (this.barrier_closed.get() && !this.in_flight_threads.isEmpty()) {
                if (target_time == 0L && this.flush_timeout > 0L) {
                    target_time = System.currentTimeMillis() + this.flush_timeout;
                }
                this.in_flight_threads.keySet().removeIf(thread -> !thread.isAlive() || thread.getState() == Thread.State.TERMINATED);
                if (this.in_flight_threads.isEmpty()) break;
                try {
                    if (this.flush_timeout <= 0L) {
                        this.no_pending_threads.await();
                        continue;
                    }
                    wait_time = target_time - System.currentTimeMillis();
                    if (wait_time <= 0L) break;
                    this.no_pending_threads.await(wait_time, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.flush_timeout > 0L && !this.in_flight_threads.isEmpty()) {
                long time = System.currentTimeMillis() - start;
                throw new TimeoutException(this.local_addr + ": failed flushing pending threads in " + time + " ms; threads:\n" + this.printInFlightThreads());
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.max_close_time > 0L) {
            this.scheduleBarrierOpener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Opens the barrier. No-op if already open")
    public void openBarrier() {
        if (!this.barrier_closed.compareAndSet(true, false)) {
            return;
        }
        this.cancelBarrierOpener();
        Map<Address, Message> map = this.mcast_queue;
        synchronized (map) {
            this.flushQueue(this.mcast_queue);
        }
        map = this.ucast_queue;
        synchronized (map) {
            this.flushQueue(this.ucast_queue);
        }
    }

    @ManagedOperation(description="Lists the in-flight threads")
    protected String printInFlightThreads() {
        return this.in_flight_threads.keySet().stream().map(Object::toString).collect(Collectors.joining("\n"));
    }

    protected void flushQueue(Map<Address, Message> queue) {
        if (queue.isEmpty()) {
            return;
        }
        for (Message msg : queue.values()) {
            boolean oob = msg.isFlagSet(Message.Flag.OOB);
            boolean internal = msg.isFlagSet(Message.Flag.INTERNAL);
            this.transport.msg_processing_policy.process(msg, oob, internal);
        }
        queue.clear();
    }

    protected void scheduleBarrierOpener() {
        if (this.barrier_opener_future == null || this.barrier_opener_future.isDone()) {
            this.barrier_opener_future = this.timer.schedule(this::openBarrier, this.max_close_time, TimeUnit.MILLISECONDS, false);
        }
    }

    protected void cancelBarrierOpener() {
        if (this.barrier_opener_future != null) {
            this.barrier_opener_future.cancel(true);
            this.barrier_opener_future = null;
        }
    }
}

