/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.concurrent;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;

public class TracedRunnable
implements Runnable {
    private final Runnable delegate;
    private final Span span;
    private final Tracer tracer;

    public TracedRunnable(Runnable delegate, Tracer tracer) {
        this(delegate, tracer, tracer.activeSpan());
    }

    public TracedRunnable(Runnable delegate, Tracer tracer, Span span) {
        this.delegate = delegate;
        this.tracer = tracer;
        this.span = span;
    }

    @Override
    public void run() {
        Scope scope = this.span == null ? null : this.tracer.scopeManager().activate(this.span);
        try {
            this.delegate.run();
        }
        finally {
            if (scope != null) {
                scope.close();
            }
        }
    }
}

