/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl;

import org.hibernate.search.exception.AssertionFailure;

public final class Throwables {
    private Throwables() {
    }

    public static RuntimeException expectRuntimeException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable == null) {
            throw new AssertionFailure("Null throwable - there is probably a bug");
        }
        throw new AssertionFailure("Unexpected throwable type - there is probably a bug", throwable);
    }

    public static Exception expectException(Throwable throwable) {
        if (throwable instanceof Exception) {
            return (Exception)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable == null) {
            throw new AssertionFailure("Null throwable - there is probably a bug");
        }
        throw new AssertionFailure("Unexpected throwable type - there is probably a bug", throwable);
    }

    public static <T extends Throwable> T combine(T throwable, T otherThrowable) {
        T toThrow = throwable;
        if (otherThrowable != null) {
            if (toThrow != null) {
                toThrow.addSuppressed(otherThrowable);
            } else {
                toThrow = otherThrowable;
            }
        }
        return toThrow;
    }
}

