/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.io.Closeable;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.protocols.relay.RELAY2;
import org.jgroups.protocols.relay.RouteStatusListener;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class RelayDemo
extends ReceiverAdapter {
    protected static final String SITE_MASTERS = "site-masters";
    protected JChannel ch;
    protected RELAY2 relay;

    public static void main(String[] args) throws Exception {
        String props = "udp.xml";
        String name = null;
        boolean print_route_status = false;
        boolean nohup = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-name")) {
                name = args[++i];
                continue;
            }
            if (args[i].equals("-print_route_status")) {
                print_route_status = Boolean.parseBoolean(args[++i]);
                continue;
            }
            if (args[i].equals("-nohup")) {
                nohup = true;
                continue;
            }
            System.out.println("RelayDemo [-props props] [-name name] [-print_route_status false|true] [-nohup]");
            return;
        }
        RelayDemo demo = new RelayDemo();
        demo.start(props, name, print_route_status, nohup);
    }

    @Override
    public void receive(Message msg) {
        Address sender = msg.getSrc();
        System.out.println("<< " + msg.getObject() + " from " + sender);
        Address dst = msg.getDest();
        if (dst == null) {
            Message rsp = new Message(msg.getSrc(), "response");
            try {
                this.ch.send(rsp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void viewAccepted(View new_view) {
        System.out.println(RelayDemo.print(new_view));
    }

    protected void start(String props, String name, boolean print_route_status, boolean nohup) throws Exception {
        this.ch = new JChannel(props).setReceiver(this);
        if (name != null) {
            this.ch.setName(name);
        }
        this.relay = (RELAY2)this.ch.getProtocolStack().findProtocol((Class<? extends Protocol>)RELAY2.class);
        if (this.relay == null) {
            throw new IllegalStateException(String.format("Protocol %s not found", RELAY2.class.getSimpleName()));
        }
        if (print_route_status) {
            this.relay.setRouteStatusListener(new RouteStatusListener(){

                @Override
                public void sitesUp(String ... sites) {
                    System.out.printf("-- %s: site(s) %s came up\n", RelayDemo.this.ch.getAddress(), String.join((CharSequence)", ", sites));
                }

                @Override
                public void sitesDown(String ... sites) {
                    System.out.printf("-- %s: site(s) %s went down\n", RelayDemo.this.ch.getAddress(), String.join((CharSequence)", ", sites));
                }
            });
        }
        this.ch.connect("RelayDemo");
        if (!nohup) {
            this.eventLoop(this.ch);
            Util.close((Closeable)this.ch);
        }
    }

    protected void eventLoop(JChannel ch) {
        while (true) {
            try {
                while (true) {
                    String line;
                    if (this.process(line = Util.readStringFromStdin(": "))) {
                        continue;
                    }
                    ch.send(null, line);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    protected boolean process(String line) {
        if (line == null || line.isEmpty()) {
            return true;
        }
        if (line.equalsIgnoreCase(SITE_MASTERS) || line.equalsIgnoreCase("sm")) {
            System.out.printf("site masters in %s: %s\n", this.relay.site(), this.relay.siteMasters());
            return true;
        }
        if (line.equalsIgnoreCase("help")) {
            RelayDemo.help();
            return true;
        }
        if (line.equalsIgnoreCase("mbrs")) {
            System.out.printf("%s: local members: %s\n", this.relay.getLocalAddress(), this.relay.members());
            return true;
        }
        if (line.equalsIgnoreCase("sites")) {
            System.out.printf("configured sites: %s\n", this.relay.getSites());
            return true;
        }
        if (line.equalsIgnoreCase("topo")) {
            System.out.printf("\n%s\n", this.printTopology());
            return true;
        }
        return false;
    }

    protected static void help() {
        System.out.println("\ncommands:\nhelp\nmbrs: prints the local members\nsite-masters (sm): prints the site masters of this site\nsites: prints the configured sites\ntopo: prints the topology (site masters and local members of all sites)\n");
    }

    protected String printTopology() {
        return this.relay.printTopology(true);
    }

    protected static String print(View view) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append(view.getClass().getSimpleName() + ": ").append(view.getViewId()).append(": ");
        for (Address mbr : view.getMembers()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(mbr);
        }
        return sb.toString();
    }
}

