/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz.jacc;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;

final class SecurityActions {
    SecurityActions() {
    }

    static <T> T doPrivileged(PrivilegedAction<T> action) {
        return SecurityActions.isChecking() ? AccessController.doPrivileged(action) : action.run();
    }

    static <T> T doPrivileged(PrivilegedExceptionAction<T> action) throws Exception {
        return SecurityActions.isChecking() ? AccessController.doPrivileged(action) : action.run();
    }

    private static boolean isChecking() {
        return System.getSecurityManager() != null;
    }
}

