/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityReference;
import org.jboss.as.clustering.controller.DefaultSubsystemDescribeHandler;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.RequirementCapability;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistration;
import org.jboss.as.clustering.controller.SubsystemRegistration;
import org.jboss.as.clustering.controller.SubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsModel;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemServiceHandler;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.XMLAttribute;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.service.UnaryRequirement;
import org.wildfly.clustering.spi.ClusteringRequirement;

public class JGroupsSubsystemResourceDefinition
extends SubsystemResourceDefinition<SubsystemRegistration> {
    public static final PathElement PATH = JGroupsSubsystemResourceDefinition.pathElement((String)"jgroups");
    static final Map<JGroupsRequirement, Capability> CAPABILITIES = new EnumMap<JGroupsRequirement, Capability>(JGroupsRequirement.class);
    static final Map<ClusteringRequirement, Capability> CLUSTERING_CAPABILITIES;

    JGroupsSubsystemResourceDefinition() {
        super(PATH, (ResourceDescriptionResolver)JGroupsExtension.SUBSYSTEM_RESOLVER);
    }

    public void register(SubsystemRegistration parentRegistration) {
        ManagementResourceRegistration registration = parentRegistration.registerSubsystemModel((ResourceDefinition)this);
        new DefaultSubsystemDescribeHandler().register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class).addCapabilities(model -> model.hasDefined(Attribute.DEFAULT_CHANNEL.getName()), CAPABILITIES.values()).addCapabilities(model -> model.hasDefined(Attribute.DEFAULT_CHANNEL.getName()), CLUSTERING_CAPABILITIES.values()).setAddOperationTransformation((UnaryOperator)new AddOperationTransformer());
        JGroupsSubsystemServiceHandler handler = new JGroupsSubsystemServiceHandler();
        new SimpleResourceRegistration(descriptor, (ResourceServiceHandler)handler).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        new ChannelResourceDefinition().register(registration);
        new StackResourceDefinition().register(registration);
    }

    static {
        for (JGroupsRequirement jGroupsRequirement : EnumSet.allOf(JGroupsRequirement.class)) {
            CAPABILITIES.put(jGroupsRequirement, (Capability)new RequirementCapability(jGroupsRequirement.getDefaultRequirement()));
        }
        CLUSTERING_CAPABILITIES = new EnumMap<ClusteringRequirement, Capability>(ClusteringRequirement.class);
        for (ClusteringRequirement clusteringRequirement : EnumSet.allOf(ClusteringRequirement.class)) {
            CLUSTERING_CAPABILITIES.put(clusteringRequirement, (Capability)new RequirementCapability(clusteringRequirement.getDefaultRequirement(), builder -> builder.setAllowMultipleRegistrations(true)));
        }
    }

    static class AddOperationTransformer
    implements UnaryOperator<OperationStepHandler> {
        AddOperationTransformer() {
        }

        @Override
        public OperationStepHandler apply(final OperationStepHandler handler) {
            return new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    if (!operation.hasDefined(Attribute.DEFAULT_CHANNEL.getName()) && operation.hasDefined(Attribute.DEFAULT_STACK.getName())) {
                        String defaultChannel = "auto";
                        PathAddress channelAddress = context.getCurrentAddress().append(new PathElement[]{ChannelResourceDefinition.pathElement(defaultChannel)});
                        ModelNode channelOperation = Util.createAddOperation((PathAddress)channelAddress);
                        channelOperation.get(ChannelResourceDefinition.Attribute.STACK.getName()).set(operation.get(Attribute.DEFAULT_STACK.getName()));
                        context.addStep(channelOperation, context.getRootResourceRegistration().getOperationHandler(channelAddress, "add"), OperationContext.Stage.MODEL);
                        operation.get(Attribute.DEFAULT_CHANNEL.getName()).set(new ModelNode(defaultChannel));
                    }
                    handler.execute(context, operation);
                }
            };
        }
    }

    public static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        DEFAULT_CHANNEL("default-channel", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setCapabilityReference((CapabilityReferenceRecorder)new CapabilityReference(CAPABILITIES.get(JGroupsRequirement.CHANNEL_FACTORY), (UnaryRequirement)JGroupsRequirement.CHANNEL_FACTORY));
            }
        }
        ,
        DEFAULT_STACK("default-stack", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setDeprecated(JGroupsModel.VERSION_3_0_0.getVersion());
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = ((SimpleAttributeDefinitionBuilder)this.apply(((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setRequired(false)).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setXmlName(XMLAttribute.DEFAULT.getLocalName()))).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

