/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.batch.operations.JobStartException;
import org.jberet.util.ObjectInputStreamWithClassloader;
import org.jboss.marshalling.cloner.ClonerConfiguration;
import org.jboss.marshalling.cloner.ObjectCloner;
import org.jboss.marshalling.cloner.ObjectClonerFactory;
import org.jboss.marshalling.cloner.ObjectCloners;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class BatchUtil {
    public static final String NL = WildFlySecurityManager.getPropertyPrivileged((String)"line.separator", (String)"\n");
    private static final String keyValDelimiter = " = ";
    private static final ObjectClonerFactory clonerFactory = AccessController.doPrivileged(new PrivilegedAction<ObjectClonerFactory>(){

        @Override
        public ObjectClonerFactory run() {
            return ObjectCloners.getSerializingObjectClonerFactory();
        }
    });
    private static final ObjectCloner cloner = AccessController.doPrivileged(new PrivilegedAction<ObjectCloner>(){

        @Override
        public ObjectCloner run() {
            return clonerFactory.createCloner(new ClonerConfiguration());
        }
    });

    public static String propertiesToString(Properties properties) {
        if (properties == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String key : properties.stringPropertyNames()) {
            sb.append(key).append(keyValDelimiter).append(properties.getProperty(key)).append(NL);
        }
        return sb.toString();
    }

    public static Properties stringToProperties(String content) {
        Properties result = new Properties();
        if (content == null || content.isEmpty()) {
            return result;
        }
        StringTokenizer st = new StringTokenizer(content, NL);
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            int delimiterPos = line.indexOf(keyValDelimiter);
            if (delimiterPos <= 0) continue;
            result.setProperty(line.substring(0, delimiterPos), line.substring(delimiterPos + keyValDelimiter.length()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] objectToBytes(Object obj) throws IOException {
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(bos);
            out.writeObject(obj);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                bos.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializable bytesToSerializableObject(byte[] bytes, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStreamWithClassloader in = null;
        try {
            in = new ObjectInputStreamWithClassloader(bis, classLoader);
            Serializable serializable = (Serializable)in.readObject();
            return serializable;
        }
        finally {
            try {
                bis.close();
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static <T> T clone(T original) throws JobStartException {
        if (original == null) {
            return null;
        }
        try {
            cloner.reset();
            return (T)cloner.clone(original);
        }
        catch (IOException e) {
            throw new JobStartException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new JobStartException((Throwable)e);
        }
    }
}

