/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.jca;

import org.jboss.as.connector.subsystems.jca.JcaSubsystemConfiguration;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

final class ArchiveValidationService
implements Service<ArchiveValidation> {
    private final ArchiveValidation value;
    private final InjectedValue<JcaSubsystemConfiguration> jcaConfig = new InjectedValue();

    public ArchiveValidationService(ArchiveValidation value) {
        this.value = value;
    }

    public ArchiveValidation getValue() throws IllegalStateException {
        return this.value;
    }

    public void start(StartContext context) throws StartException {
        ((JcaSubsystemConfiguration)this.jcaConfig.getValue()).setArchiveValidation(this.value.isEnabled());
        ((JcaSubsystemConfiguration)this.jcaConfig.getValue()).setArchiveValidationFailOnError(this.value.isFailOnError());
        ((JcaSubsystemConfiguration)this.jcaConfig.getValue()).setArchiveValidationFailOnWarn(this.value.isFailOnWarn());
    }

    public void stop(StopContext context) {
    }

    public Injector<JcaSubsystemConfiguration> getJcaConfigInjector() {
        return this.jcaConfig;
    }

    public static class ArchiveValidation {
        private final boolean enabled;
        private final boolean failOnError;
        private final boolean failOnWarn;

        public ArchiveValidation(boolean enabled, boolean failOnError, boolean failOnWarn) {
            this.enabled = enabled;
            this.failOnError = failOnError;
            this.failOnWarn = failOnWarn;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isFailOnError() {
            return this.failOnError;
        }

        public boolean isFailOnWarn() {
            return this.failOnWarn;
        }
    }
}

