/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk;

import java.util.HashMap;
import java.util.Map;

public enum IIOPInitializer {
    UNKNOWN("", ""),
    SECURITY_CLIENT("client", "org.wildfly.iiop.openjdk.csiv2.CSIv2Initializer", "org.wildfly.iiop.openjdk.csiv2.SASClientInitializer"),
    SECURITY_IDENTITY("identity", "org.wildfly.iiop.openjdk.csiv2.CSIv2Initializer", "org.wildfly.iiop.openjdk.csiv2.SASInitializer"),
    SECURITY_ELYTRON("elytron", "org.wildfly.iiop.openjdk.csiv2.CSIv2Initializer", "org.wildfly.iiop.openjdk.csiv2.ElytronSASInitializer"),
    TRANSACTIONS("transactions", "com.arjuna.ats.jts.orbspecific.javaidl.interceptors.interposition.InterpositionORBInitializerImpl", "org.jboss.iiop.tm.InboundTransactionCurrentInitializer", "org.wildfly.iiop.openjdk.tm.TxIORInterceptorInitializer", "org.wildfly.iiop.openjdk.tm.TxServerInterceptorInitializer"),
    SPEC_TRANSACTIONS("specTransactions", "org.wildfly.iiop.openjdk.tm.TxServerInterceptorInitializer");

    private final String initializerName;
    private final String[] initializerClasses;
    private static final Map<String, IIOPInitializer> MAP;

    private IIOPInitializer(String initializerName, String ... initializerClasses) {
        this.initializerName = initializerName;
        this.initializerClasses = initializerClasses;
    }

    public String getInitializerName() {
        return this.initializerName;
    }

    public String[] getInitializerClasses() {
        return this.initializerClasses;
    }

    static IIOPInitializer fromName(String initializerName) {
        IIOPInitializer element = MAP.get(initializerName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, IIOPInitializer> map = new HashMap<String, IIOPInitializer>();
        for (IIOPInitializer element : IIOPInitializer.values()) {
            String name = element.getInitializerName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

