/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.permission;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import org.wildfly.security.permission.ElytronMessages;
import org.wildfly.security.permission.PermissionVerifier;

final class UnionPermissionCollection
extends PermissionCollection
implements PermissionVerifier {
    private static final long serialVersionUID = 6731525842957764833L;
    private final PermissionCollection pc1;
    private final PermissionCollection pc2;

    UnionPermissionCollection(PermissionCollection pc1, PermissionCollection pc2) {
        this.pc1 = pc1;
        this.pc2 = pc2;
        this.setReadOnly();
    }

    @Override
    public void add(Permission permission) {
        throw ElytronMessages.log.readOnlyPermissionCollection();
    }

    @Override
    public boolean implies(Permission permission) {
        return this.pc1.implies(permission) || this.pc2.implies(permission);
    }

    @Override
    public Enumeration<Permission> elements() {
        final Enumeration<Permission> e1 = this.pc1.elements();
        final Enumeration<Permission> e2 = this.pc2.elements();
        return new Enumeration<Permission>(){

            @Override
            public boolean hasMoreElements() {
                return e1.hasMoreElements() || e2.hasMoreElements();
            }

            @Override
            public Permission nextElement() {
                return e1.hasMoreElements() ? (Permission)e1.nextElement() : (Permission)e2.nextElement();
            }
        };
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.pc1 == null) {
            throw ElytronMessages.log.invalidObjectNull("pc1");
        }
        if (this.pc2 == null) {
            throw ElytronMessages.log.invalidObjectNull("pc2");
        }
    }
}

