/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.impl;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.operation.impl.RolloutPlanGroup;
import org.jboss.dmr.ModelNode;
import org.wildfly.common.Assert;

public class SingleRolloutPlanGroup
implements RolloutPlanGroup {
    private static final int SEPARATOR_PROPERTY_LIST_START = 1;
    private static final int SEPARATOR_PROPERTY_LIST_END = 2;
    private static final int SEPARATOR_PROPERTY_VALUE = 3;
    private static final int SEPARATOR_PROPERTY = 4;
    private static final int SEPARATOR_NOT_OPERATOR = 5;
    private String groupName;
    private Map<String, String> props;
    private int lastSeparatorIndex;
    private int separator;
    private int lastChunkIndex;
    private String lastPropertyName;
    private String lastPropertyValue;
    private int lastNotOperatorIndex = -1;

    public SingleRolloutPlanGroup() {
    }

    public SingleRolloutPlanGroup(String groupName) {
        this.groupName = Assert.checkNotEmptyParam("groupName", groupName);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName, int index) {
        this.groupName = groupName;
        this.lastChunkIndex = index;
    }

    public int getLastChunkIndex() {
        return this.lastChunkIndex;
    }

    public boolean endsOnNotOperator() {
        return this.separator == 5;
    }

    public boolean isLastPropertyNegated() {
        return this.lastPropertyName != null && this.lastNotOperatorIndex + 1 == this.lastChunkIndex;
    }

    public void addProperty(String name, String value, int valueIndex) {
        Assert.checkNotEmptyParam("name", name);
        Assert.checkNotEmptyParam("value", value);
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        this.props.put(name, value);
        this.lastPropertyName = name;
        this.lastPropertyValue = value;
        this.lastChunkIndex = valueIndex;
        this.separator = -1;
    }

    public void addProperty(String name, int index) {
        Assert.checkNotEmptyParam("name", name);
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        String value = "true";
        if (name.startsWith("!")) {
            value = "false";
            name = name.substring(1);
            this.notOperator(index);
            ++index;
        }
        if (name.length() > 0) {
            this.props.put(name, value);
            this.lastPropertyName = name;
            this.lastChunkIndex = index;
            this.separator = -1;
        }
    }

    public void notOperator(int index) {
        this.separator = 5;
        this.lastNotOperatorIndex = index;
        this.lastPropertyName = null;
        this.lastPropertyValue = null;
    }

    public void propertyValueSeparator(int index) {
        this.separator = 3;
        this.lastSeparatorIndex = index;
    }

    public void propertySeparator(int index) {
        this.separator = 4;
        this.lastSeparatorIndex = index;
        this.lastPropertyName = null;
        this.lastPropertyValue = null;
    }

    public boolean hasProperties() {
        return this.lastPropertyName != null || this.props != null;
    }

    public void propertyListStart(int index) {
        this.lastSeparatorIndex = index;
        this.separator = 1;
    }

    public boolean endsOnPropertyListStart() {
        return this.separator == 1;
    }

    public void propertyListEnd(int index) {
        this.lastSeparatorIndex = index;
        this.separator = 2;
        this.lastPropertyName = null;
        this.lastPropertyValue = null;
    }

    public boolean endsOnPropertyListEnd() {
        return this.separator == 2;
    }

    public boolean endsOnPropertyValueSeparator() {
        return this.separator == 3;
    }

    public boolean endsOnPropertySeparator() {
        return this.separator == 4;
    }

    public int getLastSeparatorIndex() {
        return this.lastSeparatorIndex;
    }

    public String getLastPropertyName() {
        return this.lastPropertyName;
    }

    public String getLastPropertyValue() {
        return this.lastPropertyValue;
    }

    public boolean hasProperty(String name) {
        return this.props == null ? false : this.props.containsKey(name);
    }

    @Override
    public ModelNode toModelNode() throws CommandFormatException {
        ModelNode node = new ModelNode();
        if (this.props != null) {
            for (String propName : this.props.keySet()) {
                node.get(propName).set(this.props.get(propName));
            }
        }
        return node;
    }

    @Override
    public void addTo(ModelNode inSeries) throws CommandFormatException {
        inSeries.add().get("server-group").get(this.groupName).set(this.toModelNode());
    }
}

