/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt;

import io.smallrye.jwt.JWTLogging;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import java.util.ArrayList;
import java.util.Optional;
import org.eclipse.microprofile.jwt.Claims;

public class SmallryeJwtUtils {
    private static final Integer MAX_PATH_DEPTH = 4;
    private static final String COOKIE_HEADER = "Cookie";

    private SmallryeJwtUtils() {
    }

    public static void setContextSubPath(JWTAuthContextInfo contextInfo, Optional<String> subPath) {
        if (SmallryeJwtUtils.checkClaimPath(Claims.sub.name(), subPath)) {
            contextInfo.setSubjectPath(subPath.get());
        }
    }

    public static void setContextGroupsPath(JWTAuthContextInfo contextInfo, Optional<String> groupsPath) {
        if (SmallryeJwtUtils.checkClaimPath(Claims.groups.name(), groupsPath)) {
            contextInfo.setGroupsPath(groupsPath.get());
        }
    }

    private static boolean checkClaimPath(String claimName, Optional<String> claimPath) {
        if (claimPath.isPresent()) {
            String[] pathSegments = claimPath.get().split("/");
            if (MAX_PATH_DEPTH < pathSegments.length) {
                JWTLogging.log.maximumPathDepthReached(claimName, pathSegments.length, MAX_PATH_DEPTH);
            } else {
                return true;
            }
        }
        return false;
    }

    public static void setContextTokenCookie(JWTAuthContextInfo contextInfo, Optional<String> cookieName) {
        if (COOKIE_HEADER.equals(contextInfo.getTokenHeader()) && cookieName.isPresent()) {
            contextInfo.setTokenCookie(cookieName.get());
        }
    }

    public static void setTokenSchemes(JWTAuthContextInfo contextInfo, String tokenSchemes) {
        ArrayList<String> schemes = new ArrayList<String>();
        for (String s : tokenSchemes.split(",")) {
            schemes.add(s.trim());
        }
        contextInfo.setTokenSchemes(schemes);
    }
}

