/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.log4j;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.LoggerContext;
import org.apache.logging.log4j.spi.LoggerRegistry;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.log4j.JBossLogger;

class JBossLoggerContext
implements LoggerContext {
    private final LogContext logContext;
    private final Object externalContext;
    private final LoggerRegistry<JBossLogger> loggerRegistry = new LoggerRegistry();
    private final ConcurrentMap<String, Object> map = new ConcurrentHashMap<String, Object>();

    JBossLoggerContext(LogContext logContext, Object externalContext) {
        this.logContext = logContext;
        this.externalContext = externalContext;
    }

    public Object getExternalContext() {
        return this.externalContext;
    }

    public ExtendedLogger getLogger(String name) {
        return this.getLogger(name, null);
    }

    public ExtendedLogger getLogger(String name, MessageFactory messageFactory) {
        JBossLogger logger = (JBossLogger)this.loggerRegistry.getLogger(name, messageFactory);
        if (logger != null) {
            AbstractLogger.checkMessageFactory((ExtendedLogger)logger, (MessageFactory)messageFactory);
            return logger;
        }
        logger = new JBossLogger(this.logContext.getLogger(name), messageFactory);
        this.loggerRegistry.putIfAbsent(name, messageFactory, (ExtendedLogger)logger);
        return this.loggerRegistry.getLogger(name, messageFactory);
    }

    public boolean hasLogger(String name) {
        return this.loggerRegistry.hasLogger(name);
    }

    public boolean hasLogger(String name, MessageFactory messageFactory) {
        return this.loggerRegistry.hasLogger(name, messageFactory);
    }

    public boolean hasLogger(String name, Class<? extends MessageFactory> messageFactoryClass) {
        return this.loggerRegistry.hasLogger(name, messageFactoryClass);
    }

    public Object getObject(String key) {
        return this.map.get(key);
    }

    public Object putObject(String key, Object value) {
        return this.map.put(key, value);
    }

    public Object putObjectIfAbsent(String key, Object value) {
        return this.map.putIfAbsent(key, value);
    }

    public Object removeObject(String key) {
        return this.map.remove(key);
    }

    public boolean removeObject(String key, Object value) {
        return this.map.remove(key, value);
    }

    public int hashCode() {
        return Objects.hash(this.logContext, this.loggerRegistry, this.externalContext);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JBossLoggerContext)) {
            return false;
        }
        JBossLoggerContext other = (JBossLoggerContext)obj;
        return Objects.equals(this.logContext, other.logContext) && Objects.equals(this.loggerRegistry, other.loggerRegistry) && Objects.equals(this.externalContext, other.externalContext);
    }

    LogContext getLogContext() {
        return this.logContext;
    }
}

