/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.commit;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.common.errors.InterruptException;

public class ContextHolder {
    protected final Vertx vertx;
    private final int timeout;
    protected volatile Context context;

    public ContextHolder(Vertx vertx, int defaultTimeout) {
        this.vertx = vertx;
        this.timeout = defaultTimeout;
    }

    public void capture(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public void runOnContext(Runnable runnable) {
        if (Vertx.currentContext() == this.context && Context.isOnEventLoopThread()) {
            runnable.run();
        } else {
            this.context.runOnContext(x -> runnable.run());
        }
    }

    public <T> T runOnContextAndAwait(Callable<T> action) {
        FutureTask<T> task = new FutureTask<T>(action);
        this.runOnContext(task);
        try {
            return task.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InterruptException(e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new CompletionException(e);
        }
    }
}

