/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class JBossLevelMapping {
    public static final org.jboss.logmanager.Level DEFAULT_LEVEL = org.jboss.logmanager.Level.DEBUG;
    public static final Level DEFAULT_LOG4J_LEVEL = Level.DEBUG;
    private static final Map<java.util.logging.Level, Level> priorityMap;

    private JBossLevelMapping() {
    }

    public static Level getPriorityFor(java.util.logging.Level level) {
        Level p = priorityMap.get(level);
        return p == null ? DEFAULT_LOG4J_LEVEL : p;
    }

    public static Level getPriorityFor(int level) {
        for (java.util.logging.Level l : priorityMap.keySet()) {
            if (l.intValue() != level) continue;
            return priorityMap.get(l);
        }
        return DEFAULT_LOG4J_LEVEL;
    }

    public static java.util.logging.Level getLevelFor(Priority level) {
        if (level == null) {
            return DEFAULT_LEVEL;
        }
        switch (level.toInt()) {
            case -2147483648: {
                return org.jboss.logmanager.Level.ALL;
            }
            case 5000: {
                return org.jboss.logmanager.Level.TRACE;
            }
            case 10000: {
                return org.jboss.logmanager.Level.DEBUG;
            }
            case 20000: {
                return org.jboss.logmanager.Level.INFO;
            }
            case 30000: {
                return org.jboss.logmanager.Level.WARN;
            }
            case 40000: {
                return org.jboss.logmanager.Level.ERROR;
            }
            case 50000: {
                return org.jboss.logmanager.Level.FATAL;
            }
            case 0x7FFFFFFF: {
                return org.jboss.logmanager.Level.OFF;
            }
        }
        return DEFAULT_LEVEL;
    }

    static {
        IdentityHashMap<java.util.logging.Level, Level> map = new IdentityHashMap<java.util.logging.Level, Level>();
        map.put(java.util.logging.Level.SEVERE, Level.ERROR);
        map.put(java.util.logging.Level.WARNING, Level.WARN);
        map.put(java.util.logging.Level.CONFIG, Level.DEBUG);
        map.put(java.util.logging.Level.INFO, Level.INFO);
        map.put(java.util.logging.Level.FINE, Level.DEBUG);
        map.put(java.util.logging.Level.FINER, Level.TRACE);
        map.put(java.util.logging.Level.FINEST, Level.TRACE);
        map.put(java.util.logging.Level.OFF, Level.OFF);
        map.put((java.util.logging.Level)org.jboss.logmanager.Level.FATAL, Level.FATAL);
        map.put((java.util.logging.Level)org.jboss.logmanager.Level.ERROR, Level.ERROR);
        map.put((java.util.logging.Level)org.jboss.logmanager.Level.WARN, Level.WARN);
        map.put((java.util.logging.Level)org.jboss.logmanager.Level.INFO, Level.INFO);
        map.put((java.util.logging.Level)org.jboss.logmanager.Level.DEBUG, Level.DEBUG);
        map.put((java.util.logging.Level)org.jboss.logmanager.Level.TRACE, Level.TRACE);
        priorityMap = map;
    }
}

