/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.star.client;

import java.io.Closeable;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.enterprise.context.RequestScoped;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.jbossts.star.annotation.Commit;
import org.jboss.jbossts.star.annotation.OnePhaseCommit;
import org.jboss.jbossts.star.annotation.Prepare;
import org.jboss.jbossts.star.annotation.Rollback;
import org.jboss.jbossts.star.annotation.Status;
import org.jboss.jbossts.star.client.Current;
import org.jboss.jbossts.star.client.GenericSRAException;
import org.jboss.jbossts.star.client.IllegalSRAStateException;
import org.jboss.jbossts.star.client.InvalidSRAId;
import org.jboss.jbossts.star.client.SRAClientAPI;
import org.jboss.jbossts.star.client.SRAInfo;

@RequestScoped
public class SRAClient
implements SRAClientAPI,
Closeable {
    public static final String RTS_HTTP_CONTEXT_HEADER = "Short-Running-Action";
    public static final String RTS_HTTP_RECOVERY_HEADER = "Short-Running-Action-Recovery";
    public static final String COORDINATOR_URL_PROP = "at.http.url";
    public static final String COMMIT = "commit";
    public static final String PREPARE = "prepare";
    public static final String ROLLBACK = "rollback";
    public static final String STATUS = "participant";
    public static final String ONEPHASECOMMIT = "onephasecommit";
    private static final String TERMINATOR = "terminator";
    public static final String TIMELIMIT_PARAM_NAME = "TimeLimit";
    public static final String CLIENT_ID_PARAM_NAME = "ClientID";
    public static final String PARENT_SRA_PARAM_NAME = "ParentSRA";
    public static final long DEFAULT_TIMEOUT_MILLIS = 0L;
    private static final String startSRAUrl = "";
    private static final String getAllSRAsUrl = "/";
    private static final String getRecoveringSRAsUrl = "/recovery";
    private static final String getActiveSRAsUrl = "/active";
    private static final String isActiveUrlFormat = "/%s";
    private static final String isCompletedUrlFormat = "/completed/%s";
    private static final String isCompensatedUrlFormat = "/compensated/%s";
    private static final String TX_STATUS_MEDIA_TYPE = "application/txstatus";
    public static final String TX_COMMITTED = "txstatus=TransactionCommitted";
    public static final String TX_ROLLEDBACK = "txstatus=TransactionRolledBack";
    public static final String TX_ROLLBACK_ONLY = "txstatus=TransactionRollbackOnly";
    private static final Pattern UID_REGEXP_EXTRACT_MATCHER = Pattern.compile(".*/([^/?]+).*");
    private static final String MISSING_ANNOTATION_FORMAT = "Cannot enlist resource class %s: annotated with Transactional but is missing one or more of {@Commit. @Prepare, @Rollback, @Participant}";
    private static final Boolean isTrace = Boolean.getBoolean("trace");
    private WebTarget target;
    private URI base;
    private Client client;
    private boolean connectionInUse;
    private Map<URL, List<String>> responseDataMap;

    public SRAClient() throws URISyntaxException, MalformedURLException {
        this.init(new URL(System.getProperty(COORDINATOR_URL_PROP, "http://localhost:8080/rest-at-coordinator/tx/transaction-manager")));
    }

    private void init(URL coordinatorUrl) throws URISyntaxException {
        if (this.client == null) {
            this.client = ClientBuilder.newClient();
        }
        this.base = new URI(coordinatorUrl.toString());
        this.target = this.client.target(this.base);
        if (this.responseDataMap == null) {
            this.postConstruct();
        } else {
            this.responseDataMap.clear();
        }
    }

    @PostConstruct
    public void postConstruct() {
        this.responseDataMap = new HashMap<URL, List<String>>();
    }

    public static URL sraToURL(String sraId) {
        return SRAClient.sraToURL(sraId, "Invalid SRA id");
    }

    public static URL sraToURL(String sraId, String message) {
        try {
            return new URL(sraId);
        }
        catch (MalformedURLException e) {
            throw new GenericSRAException(null, Response.Status.BAD_REQUEST.getStatusCode(), String.format("%s: %s", message, sraId), e);
        }
    }

    public static String encodeURL(URL sraId, String message) {
        try {
            return URLEncoder.encode(sraId.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new GenericSRAException(sraId, Response.Status.BAD_REQUEST.getStatusCode(), String.format("%s: %s", message, sraId), e);
        }
    }

    public static String getSRAId(String sraId) {
        return sraId == null ? null : UID_REGEXP_EXTRACT_MATCHER.matcher(sraId).replaceFirst("$1");
    }

    public static String stripUid(URL url) {
        String urlString = url.toExternalForm();
        String id = SRAClient.getSRAId(urlString);
        if (id == null) {
            return urlString;
        }
        return urlString.substring(0, urlString.length() - id.length() - 1);
    }

    public URL toURL(String sraId) throws InvalidSRAId {
        try {
            return new URL(sraId);
        }
        catch (MalformedURLException e) {
            throw new InvalidSRAId(sraId, "Invalid syntax", e);
        }
    }

    private WebTarget getTarget() {
        return this.target;
    }

    public void setCurrentSRA(URL coordinatorUrl) {
        try {
            this.init(new URL(SRAClient.stripUid(coordinatorUrl)));
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new GenericSRAException(coordinatorUrl, Response.Status.BAD_REQUEST.getStatusCode(), e.getMessage(), e);
        }
    }

    public URL startSRA(String clientID, Long timeout) throws GenericSRAException {
        return this.startSRA(null, clientID, timeout, TimeUnit.MILLISECONDS);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public URL startSRA(URL parentSRA, String clientID, Long timeout, TimeUnit unit) throws GenericSRAException {
        Response response = null;
        if (clientID == null) {
            clientID = startSRAUrl;
        }
        if (timeout == null) {
            timeout = 0L;
        } else if (timeout < 0L) {
            throw new GenericSRAException(parentSRA, Response.Status.BAD_REQUEST.getStatusCode(), "Invalid timeout value: " + timeout, null);
        }
        this.sraTrace(String.format("startSRA for client %s with parent %s", clientID, parentSRA), null);
        try {
            String encodedParentSRA = parentSRA == null ? startSRAUrl : URLEncoder.encode(parentSRA.toString(), "UTF-8");
            this.aquireConnection();
            response = this.getTarget().path(startSRAUrl).queryParam(TIMELIMIT_PARAM_NAME, new Object[]{unit.toMillis(timeout)}).queryParam(CLIENT_ID_PARAM_NAME, new Object[]{clientID}).queryParam(PARENT_SRA_PARAM_NAME, new Object[]{encodedParentSRA}).request().post(Entity.entity((Object)String.valueOf(unit.toMillis(timeout)), (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
            this.assertEquals(response, response.getStatus(), Response.Status.CREATED.getStatusCode(), "SRA start returned an unexpected status code: %d versus %d");
            Object sraObject = response.getHeaders().getFirst((Object)RTS_HTTP_CONTEXT_HEADER);
            if (sraObject == null) {
                sraObject = response.getHeaders().getFirst((Object)"Location");
            }
            this.assertNotNull(sraObject, "SRA is null");
            URL sra = new URL(URLDecoder.decode(sraObject.toString(), "UTF-8"));
            this.sraTrace("startSRA returned", sra);
            Current.push(sra);
            this.releaseConnection(response);
            return sra;
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            try {
                throw new GenericSRAException(null, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), e.getMessage(), e);
                catch (Exception e2) {
                    if (e2.getCause() == null) throw new GenericSRAException(null, Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), e2.getMessage(), e2);
                    if (!ConnectException.class.equals(e2.getCause().getClass())) throw new GenericSRAException(null, Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), e2.getMessage(), e2);
                    throw new GenericSRAException(null, Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), "Cannont connect to an SRA coordinator: " + e2.getCause().getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                this.releaseConnection(response);
                throw throwable;
            }
        }
    }

    @Override
    public String cancelSRA(URL sraId) throws GenericSRAException {
        return this.endSRA(sraId, false);
    }

    @Override
    public String commitSRA(URL sraId) throws GenericSRAException {
        return this.endSRA(sraId, true);
    }

    public String joinSRAWithLinkHeader(URL sraUrl, Long timelimit, String linkHeader) throws GenericSRAException {
        this.sraTrace(String.format("joining SRA with compensator link: %s", linkHeader), sraUrl);
        return this.enlistCompensator(sraUrl, timelimit, linkHeader);
    }

    @Override
    public void joinSRA(URL sraId, Long timelimit, String compensatorUrl) throws GenericSRAException {
        this.sraTrace(String.format("joining SRA with compensator %s", compensatorUrl), sraId);
        this.enlistCompensator(sraId, timelimit, startSRAUrl, String.format("%s/compensate", compensatorUrl), String.format("%s/complete", compensatorUrl), String.format("%s/leave", compensatorUrl), String.format("%s/status", compensatorUrl));
    }

    @Override
    public String joinSRA(URL sraId, Long timelimit, String compensateUrl, String completeUrl, String leaveUrl, String statusUrl) throws GenericSRAException {
        return this.enlistCompensator(sraId, timelimit, startSRAUrl, compensateUrl, completeUrl, leaveUrl, statusUrl);
    }

    @Override
    public List<SRAInfo> getAllSRAs() throws GenericSRAException {
        return this.getSRAs(getAllSRAsUrl);
    }

    @Override
    public List<SRAInfo> getActiveSRAs() throws GenericSRAException {
        return this.getSRAs(getActiveSRAsUrl);
    }

    @Override
    public List<SRAInfo> getRecoveringSRAs() throws GenericSRAException {
        return this.getSRAs(getRecoveringSRAsUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SRAInfo> getSRAs(String getUrl) {
        Response response = null;
        try {
            this.aquireConnection();
            response = this.getTarget().path(getUrl).request().get();
            if (!response.hasEntity()) {
                throw new GenericSRAException(null, response.getStatus(), "missing entity body", null);
            }
            ArrayList<SRAInfo> actions = new ArrayList<SRAInfo>();
            String sras = (String)response.readEntity(String.class);
            JsonReader reader = Json.createReader((Reader)new StringReader(sras));
            JsonArray ja = reader.readArray();
            ja.forEach(jsonValue -> actions.add(this.toSRAStatus((JsonObject)jsonValue)));
            ArrayList<SRAInfo> arrayList = actions;
            this.releaseConnection(response);
            return arrayList;
        }
        catch (Throwable throwable) {
            this.releaseConnection(response);
            throw throwable;
        }
    }

    private SRAInfo toSRAStatus(JsonObject jo) {
        try {
            return new SRAInfo(jo.getString("sraId"), jo.getString("clientId"), jo.getBoolean("complete"), jo.getBoolean("compensated"), jo.getBoolean("recovering"), jo.getBoolean("active"), jo.getBoolean("topLevel"));
        }
        catch (Exception e) {
            System.out.printf("Error parsing json SRAInfo", new Object[0]);
            return new SRAInfo(jo.getString("sraId"), jo.getString("sraId"), jo.getBoolean("complete"), jo.getBoolean("compensated"), jo.getBoolean("recovering"), jo.getBoolean("active"), jo.getBoolean("topLevel"));
        }
    }

    @Override
    public Boolean isActiveSRA(URL sraId) throws GenericSRAException {
        return this.getStatus(sraId, isActiveUrlFormat);
    }

    @Override
    public Boolean isCompensatedSRA(URL sraId) throws GenericSRAException {
        return this.getStatus(sraId, isCompensatedUrlFormat);
    }

    @Override
    public Boolean isCompletedSRA(URL sraId) throws GenericSRAException {
        return this.getStatus(sraId, isCompletedUrlFormat);
    }

    public Map<String, String> getTerminationUris(URL aaId, Class<?> compensatorClass, UriInfo uriInfo, boolean validate) {
        URI baseUri = uriInfo.getBaseUri();
        HashMap<String, String> paths = new HashMap<String, String>();
        List matchedURIs = uriInfo.getMatchedURIs();
        int matchedURI = matchedURIs.size() > 1 ? 1 : 0;
        String uriPrefix = baseUri + (String)matchedURIs.get(matchedURI);
        String uid = aaId.toString().replaceFirst(".*/([^/?]+).*", "$1");
        int[] validCnt = new int[]{0};
        Arrays.stream(compensatorClass.getMethods()).forEach(method -> {
            Path pathAnnotation = method.getAnnotation(Path.class);
            if (pathAnnotation != null) {
                if (SRAClient.checkMethod(paths, method, STATUS, pathAnnotation, method.getAnnotation(Status.class), uriPrefix, uid) != 0) {
                    validCnt[0] = validCnt[0] + 1;
                }
                if (SRAClient.checkMethod(paths, method, PREPARE, pathAnnotation, method.getAnnotation(Prepare.class), uriPrefix, uid) != 0) {
                    validCnt[0] = validCnt[0] + 1;
                }
                if (SRAClient.checkMethod(paths, method, COMMIT, pathAnnotation, method.getAnnotation(Commit.class), uriPrefix, uid) != 0) {
                    validCnt[0] = validCnt[0] + 1;
                }
                if (SRAClient.checkMethod(paths, method, ROLLBACK, pathAnnotation, method.getAnnotation(Rollback.class), uriPrefix, uid) != 0) {
                    validCnt[0] = validCnt[0] + 1;
                }
                SRAClient.checkMethod(paths, method, ONEPHASECOMMIT, pathAnnotation, method.getAnnotation(OnePhaseCommit.class), uriPrefix, uid);
            }
        });
        if (validate && validCnt[0] < 4 && !paths.containsKey(COMMIT) && !paths.containsKey(ONEPHASECOMMIT)) {
            throw new GenericSRAException(null, Response.Status.BAD_REQUEST.getStatusCode(), String.format(MISSING_ANNOTATION_FORMAT, compensatorClass.getName()), null);
        }
        StringBuilder linkHeaderValue = new StringBuilder();
        paths.forEach((k, v) -> this.makeLink(linkHeaderValue, null, (String)k, (String)v));
        paths.put("Link", linkHeaderValue.toString());
        return paths;
    }

    private static int checkMethod(Map<String, String> paths, Method method, String rel, Path pathAnnotation, Annotation annotationClass, String uriPrefix, String aaId) {
        if (annotationClass == null) {
            return 0;
        }
        for (Annotation annotation : method.getDeclaredAnnotations()) {
            String name = annotation.annotationType().getName();
            if (!name.equals(GET.class.getName()) && !name.equals(PUT.class.getName()) && !name.equals(POST.class.getName()) && !name.equals(DELETE.class.getName())) continue;
            String pathValue = pathAnnotation.value();
            String s1 = pathAnnotation.value().replaceAll("\\{txid}", aaId);
            String url = String.format("%s%s", uriPrefix, s1);
            paths.put(rel, url);
            break;
        }
        return 1;
    }

    private boolean xcheckMethod(Map<String, String> paths, String rel, Path pathAnnotation, Annotation annotationClass, String uriPrefix, String aaId) {
        if (annotationClass == null) {
            return false;
        }
        paths.put(rel, String.format("%s%s", uriPrefix, pathAnnotation.value().replaceAll("\\{txid}", aaId)));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean getStatus(URL sraId, String statusFormat) {
        Response response = null;
        try {
            this.aquireConnection();
            response = this.getTarget().path("status").path(String.format(statusFormat, SRAClient.getSRAId(sraId.toString()))).request().get();
            Boolean bl = Boolean.valueOf((String)response.readEntity(String.class));
            this.releaseConnection(response);
            return bl;
        }
        catch (Throwable throwable) {
            this.releaseConnection(response);
            throw throwable;
        }
    }

    private StringBuilder makeLink(StringBuilder b, String uriPrefix, String key, String value) {
        String terminationUri = uriPrefix == null ? value : String.format("%s%s", uriPrefix, value);
        Link link = Link.fromUri((String)terminationUri).title(key + " URI").rel(key).type("text/plain").build(new Object[0]);
        if (b.length() != 0) {
            b.append(',');
        }
        return b.append(link);
    }

    private String enlistCompensator(URL sraUrl, long timelimit, String uriPrefix, String compensateUrl, String completeUrl, String leaveUrl, String statusUrl) {
        this.validateURL(completeUrl, false, "Invalid complete URL: %s");
        this.validateURL(compensateUrl, false, "Invalid compensate URL: %s");
        this.validateURL(leaveUrl, true, "Invalid status URL: %s");
        this.validateURL(statusUrl, false, "Invalid status URL: %s");
        HashMap<String, String> terminateURIs = new HashMap<String, String>();
        terminateURIs.put(PREPARE, compensateUrl);
        terminateURIs.put(COMMIT, completeUrl);
        terminateURIs.put(ROLLBACK, leaveUrl);
        terminateURIs.put(STATUS, statusUrl);
        StringBuilder linkHeaderValue = new StringBuilder();
        terminateURIs.forEach((k, v) -> this.makeLink(linkHeaderValue, uriPrefix, (String)k, (String)v));
        return this.enlistCompensator(sraUrl, timelimit, linkHeaderValue.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String enlistCompensator(URL sraUrl, long timelimit, String linkHeader) {
        Response response = null;
        if (timelimit < 0L) {
            timelimit = 0L;
        }
        try {
            String uid = sraUrl.toString();
            WebTarget wt = this.getTarget();
            if (!wt.getUri().toASCIIString().endsWith(uid)) {
                wt = this.getTarget().path(SRAClient.getSRAId(sraUrl.toString()));
            }
            if ((response = wt.queryParam(TIMELIMIT_PARAM_NAME, new Object[]{timelimit}).request().header("Link", (Object)linkHeader).header(RTS_HTTP_CONTEXT_HEADER, (Object)sraUrl).post(Entity.entity((Object)linkHeader, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE))).getStatus() == Response.Status.PRECONDITION_FAILED.getStatusCode()) {
                throw new IllegalSRAStateException(sraUrl.toString(), "Too late to join with this SRA", null);
            }
            if (response.getStatus() != Response.Status.CREATED.getStatusCode()) {
                String reason = (String)response.readEntity(String.class);
                this.sraTrace(String.format("enlist in SRA failed (%d): %s", response.getStatus(), response.readEntity(String.class)), sraUrl);
                throw new GenericSRAException(sraUrl, response.getStatus(), "unable to register particiapnt: " + reason, null);
            }
            if (!response.getHeaders().containsKey((Object)"Location")) {
                String reason = (String)response.readEntity(String.class);
                throw new GenericSRAException(sraUrl, response.getStatus(), "participant registration did not return a recovery URL: " + reason, null);
            }
            String string = response.getHeaders().getFirst((Object)"Location").toString();
            this.releaseConnection(response);
            return string;
        }
        catch (Throwable throwable) {
            this.releaseConnection(response);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String endSRA(URL sra, boolean commit) throws GenericSRAException {
        String string;
        String targetState = commit ? TX_COMMITTED : TX_ROLLEDBACK;
        Response response = null;
        this.sraTrace(String.format("%s SRA", commit ? COMMIT : ROLLBACK), sra);
        try {
            response = this.getTarget().path(SRAClient.getSRAId(sra.toString())).path(TERMINATOR).request().put(Entity.entity((Object)targetState, (String)TX_STATUS_MEDIA_TYPE));
            this.assertEquals(response, Response.Status.OK.getStatusCode(), response.getStatus(), "SRA finished with an unexpected status code: " + response.getStatus());
            string = (String)response.readEntity(String.class);
            this.releaseConnection(response);
        }
        catch (Throwable throwable) {
            this.releaseConnection(response);
            Current.pop(sra);
            URL nextSRA = Current.peek();
            if (nextSRA != null) {
                try {
                    this.init(nextSRA);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        Current.pop(sra);
        URL nextSRA = Current.peek();
        if (nextSRA != null) {
            try {
                this.init(nextSRA);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return string;
    }

    private void validateURL(String url, boolean nullAllowed, String message) {
        if (url == null) {
            if (!nullAllowed) {
                throw new GenericSRAException(null, Response.Status.NOT_ACCEPTABLE.getStatusCode(), String.format(message, "null value"), null);
            }
        } else {
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                throw new GenericSRAException(null, Response.Status.NOT_ACCEPTABLE.getStatusCode(), String.format(message, e.getMessage()), e);
            }
        }
    }

    private void assertNotNull(Object sra, String message) {
        if (sra == null) {
            throw new GenericSRAException(null, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), message, null);
        }
    }

    private void assertEquals(Response response, Object expected, Object actual, String messageFormat) {
        if (!actual.equals(expected)) {
            throw new GenericSRAException(null, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), String.format(messageFormat, expected, actual), null);
        }
    }

    public String getUrl() {
        return this.base.toString();
    }

    @Override
    public URL getCurrent() {
        return Current.peek();
    }

    private void sraTrace(String reason, URL sra) {
        if (isTrace.booleanValue()) {
            System.out.printf("SRAClient: %s: sra: %s%n", reason, sra == null ? "null" : sra);
        }
    }

    @Override
    public void close() {
        this.client.close();
        if (this.responseDataMap != null) {
            this.responseDataMap.clear();
        }
    }

    private void aquireConnection() {
        if (this.connectionInUse) {
            System.out.printf("SRAClient: trying to aquire an in use connection", new Object[0]);
            throw new GenericSRAException(null, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "SRAClient: trying to aquire an in use connection", null);
        }
        this.connectionInUse = true;
    }

    private void releaseConnection(Response response) {
        if (response != null) {
            response.close();
        }
        this.connectionInUse = false;
    }

    @Override
    public List<String> getResponseData(URL sraId) {
        return this.responseDataMap.getOrDefault(sraId, Collections.emptyList());
    }
}

