/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.mirror;

import java.util.HashMap;
import java.util.List;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPMirrorBrokerConnectionElement;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.server.mirror.MirrorController;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessageBrokerAccessor;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.connect.AMQPBrokerConnection;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerTarget;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorMessageFactory;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.BasicMirrorController;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.ReferenceNodeStore;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.engine.Sender;
import org.jboss.logging.Logger;

public class AMQPMirrorControllerSource
extends BasicMirrorController<Sender>
implements MirrorController,
ActiveMQComponent {
    private static final Logger logger = Logger.getLogger(AMQPMirrorControllerSource.class);
    public static final Symbol EVENT_TYPE = Symbol.getSymbol((String)"x-opt-amq-mr-ev-type");
    public static final Symbol ADDRESS = Symbol.getSymbol((String)"x-opt-amq-mr-adr");
    public static final Symbol QUEUE = Symbol.getSymbol((String)"x-opt-amq-mr-qu");
    public static final Symbol BROKER_ID = Symbol.getSymbol((String)"x-opt-amq-bkr-id");
    public static final Symbol ADD_ADDRESS = Symbol.getSymbol((String)"addAddress");
    public static final Symbol DELETE_ADDRESS = Symbol.getSymbol((String)"deleteAddress");
    public static final Symbol CREATE_QUEUE = Symbol.getSymbol((String)"createQueue");
    public static final Symbol DELETE_QUEUE = Symbol.getSymbol((String)"deleteQueue");
    public static final Symbol POST_ACK = Symbol.getSymbol((String)"postAck");
    public static final Symbol INTERNAL_ID = Symbol.getSymbol((String)"x-opt-amq-mr-id");
    public static final Symbol INTERNAL_DESTINATION = Symbol.getSymbol((String)"x-opt-amq-mr-dst");
    public static final Symbol MIRROR_CAPABILITY = Symbol.getSymbol((String)"amq.mirror");
    public static final Symbol QPID_DISPATCH_WAYPOINT_CAPABILITY = Symbol.valueOf((String)"qd.waypoint");
    public static final SimpleString INTERNAL_ID_EXTRA_PROPERTY = SimpleString.toSimpleString((String)INTERNAL_ID.toString());
    public static final SimpleString INTERNAL_BROKER_ID_EXTRA_PROPERTY = SimpleString.toSimpleString((String)BROKER_ID.toString());
    private static final ThreadLocal<MirrorControlRouting> mirrorControlRouting = ThreadLocal.withInitial(() -> new MirrorControlRouting(null));
    final Queue snfQueue;
    final ActiveMQServer server;
    final ReferenceNodeStore idSupplier;
    final boolean acks;
    final boolean addQueues;
    final boolean deleteQueues;
    private final AMQPBrokerConnection brokerConnection;
    final AMQPMirrorBrokerConnectionElement replicaConfig;
    boolean started;

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public boolean isStarted() {
        return this.started;
    }

    public AMQPMirrorControllerSource(ProtonProtocolManager protonProtocolManager, Queue snfQueue, ActiveMQServer server, AMQPMirrorBrokerConnectionElement replicaConfig, AMQPBrokerConnection brokerConnection) {
        super(server);
        this.replicaConfig = replicaConfig;
        this.snfQueue = snfQueue;
        this.server = server;
        this.idSupplier = protonProtocolManager.getReferenceIDSupplier();
        this.addQueues = replicaConfig.isQueueCreation();
        this.deleteQueues = replicaConfig.isQueueRemoval();
        this.acks = replicaConfig.isMessageAcknowledgements();
        this.brokerConnection = brokerConnection;
    }

    public Queue getSnfQueue() {
        return this.snfQueue;
    }

    public AMQPBrokerConnection getBrokerConnection() {
        return this.brokerConnection;
    }

    public void addAddress(AddressInfo addressInfo) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this.server + " addAddress " + addressInfo));
        }
        if (AMQPMirrorControllerTarget.getControllerInUse() != null && !addressInfo.isInternal()) {
            return;
        }
        if (this.addQueues) {
            Message message = this.createMessage(addressInfo.getName(), null, ADD_ADDRESS, null, addressInfo.toJSON());
            AMQPMirrorControllerSource.route(this.server, message);
        }
    }

    public void deleteAddress(AddressInfo addressInfo) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this.server + " deleteAddress " + addressInfo));
        }
        if (this.invalidTarget(AMQPMirrorControllerTarget.getControllerInUse()) || addressInfo.isInternal()) {
            return;
        }
        if (this.deleteQueues) {
            Message message = this.createMessage(addressInfo.getName(), null, DELETE_ADDRESS, null, addressInfo.toJSON());
            AMQPMirrorControllerSource.route(this.server, message);
        }
    }

    public void createQueue(QueueConfiguration queueConfiguration) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this.server + " createQueue " + queueConfiguration));
        }
        if (this.invalidTarget(AMQPMirrorControllerTarget.getControllerInUse()) || queueConfiguration.isInternal().booleanValue()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Rejecting ping pong on create " + queueConfiguration + " as isInternal=" + queueConfiguration.isInternal() + " and mirror target = " + AMQPMirrorControllerTarget.getControllerInUse()));
            }
            return;
        }
        if (this.addQueues) {
            Message message = this.createMessage(queueConfiguration.getAddress(), queueConfiguration.getName(), CREATE_QUEUE, null, queueConfiguration.toJSON());
            AMQPMirrorControllerSource.route(this.server, message);
        }
    }

    public void deleteQueue(SimpleString address, SimpleString queue) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this.server + " deleteQueue " + address + "/" + queue));
        }
        if (this.invalidTarget(AMQPMirrorControllerTarget.getControllerInUse())) {
            return;
        }
        if (this.deleteQueues) {
            Message message = this.createMessage(address, queue, DELETE_QUEUE, null, queue.toString());
            AMQPMirrorControllerSource.route(this.server, message);
        }
    }

    private boolean invalidTarget(MirrorController controller) {
        return controller != null && this.sameNode(this.getRemoteMirrorId(), controller.getRemoteMirrorId());
    }

    private boolean sameNode(String remoteID, String sourceID) {
        return remoteID != null && sourceID != null && remoteID.equals(sourceID);
    }

    public void sendMessage(Message message, RoutingContext context, List<MessageReference> refs) {
        if (this.invalidTarget(context.getMirrorSource())) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("server " + this.server + " is discarding send to avoid infinite loop (reflection with the mirror)"));
            }
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this.server + " send message " + message));
        }
        try {
            context.setReusable(false);
            MessageReference ref = MessageReference.Factory.createReference((Message)message, (Queue)this.snfQueue);
            String nodeID = AMQPMirrorControllerSource.setProtocolData(this.idSupplier, ref);
            if (nodeID != null && nodeID.equals(this.getRemoteMirrorId())) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Message " + message + "already belonged to the node, " + this.getRemoteMirrorId() + ", it won't circle send"));
                }
                return;
            }
            this.snfQueue.refUp(ref);
            refs.add(ref);
            message.usageUp();
            if (message.isDurable() && this.snfQueue.isDurable()) {
                PostOfficeImpl.storeDurableReference((StorageManager)this.server.getStorageManager(), (Message)message, (Transaction)context.getTransaction(), (Queue)this.snfQueue, (boolean)true);
            }
        }
        catch (Throwable e) {
            logger.warn((Object)e.getMessage(), e);
        }
    }

    public static void validateProtocolData(ReferenceNodeStore referenceIDSupplier, MessageReference ref, SimpleString snfAddress) {
        if (ref.getProtocolData() == null && !ref.getMessage().getAddressSimpleString().equals((Object)snfAddress)) {
            AMQPMirrorControllerSource.setProtocolData(referenceIDSupplier, ref);
        }
    }

    private static String setProtocolData(ReferenceNodeStore referenceIDSupplier, MessageReference ref) {
        Properties amqpProperties;
        HashMap<Symbol, Object> daMap = new HashMap<Symbol, Object>();
        DeliveryAnnotations deliveryAnnotations = new DeliveryAnnotations(daMap);
        String brokerID = referenceIDSupplier.getServerID(ref);
        if (brokerID != null) {
            daMap.put(BROKER_ID, brokerID);
        }
        long id = referenceIDSupplier.getID(ref);
        daMap.put(INTERNAL_ID, id);
        String address = ref.getMessage().getAddress();
        if (!(address == null || (amqpProperties = AMQPMirrorControllerSource.getProperties(ref.getMessage())) != null && address.equals(amqpProperties.getTo()))) {
            daMap.put(INTERNAL_DESTINATION, ref.getMessage().getAddress());
        }
        ref.setProtocolData((Object)deliveryAnnotations);
        return brokerID;
    }

    private static Properties getProperties(Message message) {
        if (message instanceof AMQPMessage) {
            return AMQPMessageBrokerAccessor.getCurrentProperties((AMQPMessage)message);
        }
        return null;
    }

    public void postAcknowledge(MessageReference ref, AckReason reason) throws Exception {
        MirrorController controllerInUse = AMQPMirrorControllerTarget.getControllerInUse();
        if (!this.acks || ref.getQueue().isMirrorController()) {
            return;
        }
        if (this.invalidTarget(controllerInUse)) {
            return;
        }
        if (ref.getQueue() != null && (ref.getQueue().isInternalQueue() || ref.getQueue().isMirrorController())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.server + " rejecting postAcknowledge queue=" + ref.getQueue().getName() + ", ref=" + ref + " to avoid infinite loop with the mirror (reflection)"));
            }
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this.server + " postAcknowledge " + ref));
        }
        String nodeID = this.idSupplier.getServerID(ref);
        long internalID = this.idSupplier.getID(ref);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this.server + " sending ack message from server " + nodeID + " with messageID=" + internalID));
        }
        Message message = this.createMessage(ref.getQueue().getAddress(), ref.getQueue().getName(), POST_ACK, nodeID, internalID);
        AMQPMirrorControllerSource.route(this.server, message);
        ref.getMessage().usageDown();
    }

    private Message createMessage(SimpleString address, SimpleString queue, Object event, String brokerID, Object body) {
        return AMQPMirrorMessageFactory.createMessage(this.snfQueue.getAddress().toString(), address, queue, event, brokerID, body);
    }

    public static void route(ActiveMQServer server, Message message) throws Exception {
        message.setMessageID(server.getStorageManager().generateID());
        MirrorControlRouting ctx = mirrorControlRouting.get();
        ctx.clear();
        server.getPostOffice().route(message, (RoutingContext)ctx, false);
    }

    private static class MirrorControlRouting
    extends RoutingContextImpl {
        MirrorControlRouting(Transaction transaction) {
            super(transaction);
        }

        public boolean isMirrorController() {
            return true;
        }
    }
}

