/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.client;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQRemoteDisconnectException;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.protocol.amqp.broker.ActiveMQProtonRemotingConnection;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.client.AMQPClientConnectionFactory;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.EventHandler;
import org.apache.activemq.artemis.protocol.amqp.sasl.ClientSASLFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.BaseConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.jboss.logging.Logger;

public class ProtonClientConnectionManager
implements BaseConnectionLifeCycleListener<ProtonProtocolManager>,
BufferHandler {
    private final Map<Object, ActiveMQProtonRemotingConnection> connectionMap = new ConcurrentHashMap<Object, ActiveMQProtonRemotingConnection>();
    private static final Logger log = Logger.getLogger(ProtonClientConnectionManager.class);
    private final AMQPClientConnectionFactory connectionFactory;
    private final Optional<EventHandler> eventHandler;
    private final ClientSASLFactory clientSASLFactory;

    public ProtonClientConnectionManager(AMQPClientConnectionFactory connectionFactory, Optional<EventHandler> eventHandler, ClientSASLFactory clientSASLFactory) {
        this.connectionFactory = connectionFactory;
        this.eventHandler = eventHandler;
        this.clientSASLFactory = clientSASLFactory;
    }

    public void connectionCreated(ActiveMQComponent component, Connection connection, ProtonProtocolManager protocolManager) {
        ActiveMQProtonRemotingConnection amqpConnection = this.connectionFactory.createConnection(protocolManager, connection, this.eventHandler, this.clientSASLFactory);
        this.connectionMap.put(connection.getID(), amqpConnection);
        amqpConnection.open();
        log.info((Object)("Connection " + amqpConnection.getRemoteAddress() + " created"));
    }

    public void connectionDestroyed(Object connectionID) {
        RemotingConnection connection = (RemotingConnection)this.connectionMap.remove(connectionID);
        if (connection != null) {
            log.info((Object)("Connection " + connection.getRemoteAddress() + " destroyed"));
            connection.fail((ActiveMQException)new ActiveMQRemoteDisconnectException());
        } else {
            log.error((Object)("Connection with id " + connectionID + " not found in connectionDestroyed"));
        }
    }

    public void connectionException(Object connectionID, ActiveMQException me) {
        RemotingConnection connection = (RemotingConnection)this.connectionMap.get(connectionID);
        if (connection != null) {
            log.info((Object)("Connection " + connection.getRemoteAddress() + " exception: " + me.getMessage()));
            connection.fail(me);
        } else {
            log.error((Object)("Connection with id " + connectionID + " not found in connectionException"));
        }
    }

    public void connectionReadyForWrites(Object connectionID, boolean ready) {
        RemotingConnection connection = (RemotingConnection)this.connectionMap.get(connectionID);
        if (connection != null) {
            log.info((Object)("Connection " + connection.getRemoteAddress() + " ready"));
            connection.getTransportConnection().fireReady(true);
        } else {
            log.error((Object)("Connection with id " + connectionID + " not found in connectionReadyForWrites()!"));
        }
    }

    public void stop() {
        for (RemotingConnection remotingConnection : this.connectionMap.values()) {
            remotingConnection.destroy();
        }
    }

    public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
        RemotingConnection connection = (RemotingConnection)this.connectionMap.get(connectionID);
        if (connection != null) {
            connection.bufferReceived(connectionID, buffer);
        } else {
            log.error((Object)("Connection with id " + connectionID + " not found in bufferReceived()!"));
        }
    }

    public RemotingConnection getConnection(Object connectionId) {
        return (RemotingConnection)this.connectionMap.get(connectionId);
    }
}

