/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.Handlers;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.predicate.Predicate;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.RedirectHandler;
import io.undertow.server.handlers.SetAttributeHandler;
import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.undertow.filters.Filter;

public class RewriteFilterDefinition
extends Filter {
    public static final AttributeDefinition TARGET = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("target", ModelType.STRING).setRequired(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition REDIRECT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("redirect", ModelType.BOOLEAN).setRequired(false)).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final RewriteFilterDefinition INSTANCE = new RewriteFilterDefinition();

    private RewriteFilterDefinition() {
        super("rewrite");
    }

    @Override
    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(TARGET, REDIRECT);
    }

    @Override
    public HttpHandler createHttpHandler(Predicate predicate, ModelNode model, HttpHandler next) {
        String expression = model.get(TARGET.getName()).asString();
        boolean redirect = model.get(REDIRECT.getName()).asBoolean();
        if (predicate == null) {
            return this.create(next, expression, redirect);
        }
        return Handlers.predicate((Predicate)predicate, (HttpHandler)this.create(next, expression, redirect), (HttpHandler)next);
    }

    public HttpHandler create(HttpHandler next, String expression, boolean redirect) {
        if (redirect) {
            return new RedirectHandler(expression);
        }
        return new SetAttributeHandler(next, ExchangeAttributes.relativePath(), ExchangeAttributes.parser((ClassLoader)this.getClass().getClassLoader()).parse(expression));
    }

    @Override
    protected Class[] getConstructorSignature() {
        throw new IllegalStateException();
    }
}

