/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules.xml;

import java.util.ArrayList;
import java.util.List;

class SystemPropertyConditionBuilder {
    private final List<Condition> conditions = new ArrayList<Condition>();

    SystemPropertyConditionBuilder() {
    }

    public boolean resolve() {
        for (Condition condition : this.conditions) {
            if (condition.get()) continue;
            return false;
        }
        return true;
    }

    public SystemPropertyConditionBuilder add(String name, String value, boolean equal) {
        this.conditions.add(new Condition(name, value, equal));
        return this;
    }

    private static class Condition {
        private final String name;
        private final String value;
        private final boolean equal;

        private Condition(String name, String value, boolean equal) {
            this.name = name;
            this.value = value;
            this.equal = equal;
        }

        public boolean get() {
            String pval = System.getProperty(this.name);
            boolean equalValue = pval == null ? this.value.isEmpty() : this.value.equals(pval);
            return this.equal == equalValue;
        }
    }
}

