/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.metrics;

import io.smallrye.metrics.ExtendedMetadata;
import io.smallrye.metrics.MetricRegistries;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.wildfly.extension.metrics.MetricMetadata;
import org.wildfly.extension.microprofile.metrics._private.MicroProfileMetricsLogger;

public class MicroProfileVendorMetricRegistry
implements org.wildfly.extension.metrics.MetricRegistry {
    final MetricRegistry vendorRegistry = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMetric(final org.wildfly.extension.metrics.Metric metric, MetricMetadata metadata) {
        Object mpMetric = metadata.getType() == MetricMetadata.Type.COUNTER ? new Counter(){

            public void inc() {
            }

            public void inc(long n) {
            }

            public long getCount() {
                OptionalDouble value = metric.getValue();
                if (!value.isPresent()) {
                    throw MicroProfileMetricsLogger.LOGGER.metricUnavailable();
                }
                return (long)value.getAsDouble();
            }
        } : new Gauge<Number>(){

            public Double getValue() {
                OptionalDouble value = metric.getValue();
                if (!value.isPresent()) {
                    throw MicroProfileMetricsLogger.LOGGER.metricUnavailable();
                }
                return value.getAsDouble();
            }
        };
        this.lock.writeLock().lock();
        try {
            MetricRegistry metricRegistry = this.vendorRegistry;
            synchronized (metricRegistry) {
                Metadata existingMetadata = (Metadata)this.vendorRegistry.getMetadata().get(metadata.getMetricName());
                Object mpMetadata = existingMetadata != null ? existingMetadata : new ExtendedMetadata(metadata.getMetricName(), metadata.getMetricName(), metadata.getDescription(), metadata.getType() == MetricMetadata.Type.COUNTER ? MetricType.COUNTER : MetricType.GAUGE, this.metricUnit(metadata.getMeasurementUnit()), null, false, Optional.of(false));
                Tag[] mpTags = this.toMicroProfileMetricsTags(metadata.getTags());
                this.vendorRegistry.register(mpMetadata, (Metric)mpMetric, mpTags);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void unregister(org.wildfly.extension.metrics.MetricID metricID) {
        this.lock.writeLock().lock();
        try {
            this.vendorRegistry.remove(this.toMicroProfileMetricID(metricID));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void readLock() {
        this.lock.readLock().lock();
    }

    public void unlock() {
        this.lock.readLock().unlock();
    }

    private MetricID toMicroProfileMetricID(org.wildfly.extension.metrics.MetricID metricID) {
        return new MetricID(metricID.getMetricName(), this.toMicroProfileMetricsTags(metricID.getTags()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllMetrics() {
        this.lock.writeLock().lock();
        try {
            for (MetricRegistry registry : new MetricRegistry[]{MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.BASE), MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR)}) {
                for (String name : registry.getNames()) {
                    registry.remove(name);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private Tag[] toMicroProfileMetricsTags(MetricMetadata.MetricTag[] tags) {
        if (tags == null || tags.length == 0) {
            return new Tag[0];
        }
        Tag[] mpTags = new Tag[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            mpTags[i] = new Tag(tags[i].getKey(), tags[i].getValue());
        }
        return mpTags;
    }

    private String metricUnit(MeasurementUnit unit) {
        if (unit == null) {
            return "none";
        }
        switch (unit) {
            case PERCENTAGE: {
                return "percent";
            }
            case BYTES: {
                return "bytes";
            }
            case KILOBYTES: {
                return "kilobytes";
            }
            case MEGABYTES: {
                return "megabytes";
            }
            case GIGABYTES: {
                return "gigabytes";
            }
            case TERABYTES: {
                return "terabytes";
            }
            case PETABYTES: {
                return "petabytes";
            }
            case BITS: {
                return "bits";
            }
            case KILOBITS: {
                return "kilobits";
            }
            case MEGABITS: {
                return "mebibits";
            }
            case GIGABITS: {
                return "gigabits";
            }
            case TERABITS: {
                return "terabits";
            }
            case PETABITS: {
                return "petabits";
            }
            case EPOCH_MILLISECONDS: {
                return "milliseconds";
            }
            case EPOCH_SECONDS: {
                return "seconds";
            }
            case JIFFYS: {
                return "jiffys";
            }
            case NANOSECONDS: {
                return "nanoseconds";
            }
            case MICROSECONDS: {
                return "microseconds";
            }
            case MILLISECONDS: {
                return "milliseconds";
            }
            case SECONDS: {
                return "seconds";
            }
            case MINUTES: {
                return "minutes";
            }
            case HOURS: {
                return "hours";
            }
            case DAYS: {
                return "days";
            }
            case PER_JIFFY: {
                return "per-jiffy";
            }
            case PER_NANOSECOND: {
                return "per_nanoseconds";
            }
            case PER_MICROSECOND: {
                return "per_microseconds";
            }
            case PER_MILLISECOND: {
                return "per_milliseconds";
            }
            case PER_SECOND: {
                return "per_second";
            }
            case PER_MINUTE: {
                return "per_minutes";
            }
            case PER_HOUR: {
                return "per_hour";
            }
            case PER_DAY: {
                return "per_day";
            }
            case CELSIUS: {
                return "degree_celsius";
            }
            case KELVIN: {
                return "kelvin";
            }
            case FAHRENHEIGHT: {
                return "degree_fahrenheit";
            }
        }
        return "none";
    }
}

