/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpScopeNotification;
import org.wildfly.security.http.Scope;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.OidcAccount;
import org.wildfly.security.http.oidc.OidcClientConfiguration;
import org.wildfly.security.http.oidc.OidcHttpFacade;
import org.wildfly.security.http.oidc.OidcPrincipal;
import org.wildfly.security.http.oidc.OidcSecurityContext;
import org.wildfly.security.http.oidc.OidcTokenStore;
import org.wildfly.security.http.oidc.RefreshableOidcSecurityContext;
import org.wildfly.security.http.oidc.RequestAuthenticator;

public class OidcSessionTokenStore
implements OidcTokenStore {
    private final OidcHttpFacade httpFacade;

    public OidcSessionTokenStore(OidcHttpFacade httpFacade) {
        this.httpFacade = httpFacade;
    }

    @Override
    public void checkCurrentToken() {
        HttpScope session = this.httpFacade.getScope(Scope.SESSION);
        if (session == null || !session.exists()) {
            return;
        }
        RefreshableOidcSecurityContext securityContext = (RefreshableOidcSecurityContext)session.getAttachment(OidcSecurityContext.class.getName());
        if (securityContext == null) {
            return;
        }
        if (securityContext.getOidcClientConfiguration() == null) {
            securityContext.setCurrentRequestInfo(this.httpFacade.getOidcClientConfiguration(), this);
        }
        if (securityContext.isActive() && !securityContext.getOidcClientConfiguration().isAlwaysRefreshToken()) {
            return;
        }
        boolean success = securityContext.refreshToken(false);
        if (success && securityContext.isActive()) {
            return;
        }
        session.setAttachment(OidcSecurityContext.class.getName(), null);
        session.invalidate();
    }

    @Override
    public boolean isCached(RequestAuthenticator authenticator) {
        OidcAccount account;
        HttpScope session = this.httpFacade.getScope(Scope.SESSION);
        if (session == null || !session.supportsAttachments()) {
            ElytronMessages.log.debug("session was null, returning null");
            return false;
        }
        try {
            account = (OidcAccount)session.getAttachment(OidcAccount.class.getName());
        }
        catch (IllegalStateException e) {
            ElytronMessages.log.debug("session was invalidated.  Return false.");
            return false;
        }
        if (account == null) {
            ElytronMessages.log.debug("Account was not in session, returning null");
            return false;
        }
        OidcClientConfiguration deployment = this.httpFacade.getOidcClientConfiguration();
        if (deployment.getRealm() != null && !deployment.getRealm().equals(account.getOidcSecurityContext().getRealm())) {
            ElytronMessages.log.debug("Account in session belongs to a different realm than for this request.");
            return false;
        }
        boolean active = account.checkActive();
        if (!active) {
            active = account.tryRefresh();
        }
        if (active) {
            ElytronMessages.log.debug("Cached account found");
            this.restoreRequest();
            this.httpFacade.authenticationComplete(account, true);
            return true;
        }
        ElytronMessages.log.debug("Refresh failed. Account was not active. Returning null and invalidating Http session");
        try {
            session.setAttachment(OidcSecurityContext.class.getName(), null);
            session.setAttachment(OidcAccount.class.getName(), null);
            session.invalidate();
        }
        catch (Exception e) {
            ElytronMessages.log.debug("Failed to invalidate session, might already be invalidated");
        }
        return false;
    }

    @Override
    public void saveAccountInfo(OidcAccount account) {
        HttpScope session = this.httpFacade.getScope(Scope.SESSION);
        if (!session.exists()) {
            session.create();
            session.registerForNotification(httpScopeNotification -> {
                HttpScope invalidated;
                if (!httpScopeNotification.isOfType(HttpScopeNotification.SessionNotificationType.UNDEPLOY) && (invalidated = httpScopeNotification.getScope(Scope.SESSION)) != null) {
                    invalidated.setAttachment(OidcAccount.class.getName(), null);
                    invalidated.setAttachment(OidcSecurityContext.class.getName(), null);
                }
            });
        }
        session.setAttachment(OidcAccount.class.getName(), account);
        session.setAttachment(OidcSecurityContext.class.getName(), account.getOidcSecurityContext());
        HttpScope scope = this.httpFacade.getScope(Scope.EXCHANGE);
        scope.setAttachment(OidcSecurityContext.class.getName(), account.getOidcSecurityContext());
    }

    @Override
    public void logout() {
        this.logout(false);
    }

    @Override
    public void refreshCallback(RefreshableOidcSecurityContext securityContext) {
        OidcPrincipal<RefreshableOidcSecurityContext> principal = new OidcPrincipal<RefreshableOidcSecurityContext>(securityContext.getIDToken().getPrincipalName(this.httpFacade.getOidcClientConfiguration()), securityContext);
        this.saveAccountInfo(new OidcAccount(principal));
    }

    @Override
    public void saveRequest() {
        this.httpFacade.suspendRequest();
    }

    @Override
    public boolean restoreRequest() {
        return this.httpFacade.restoreRequest();
    }

    @Override
    public void logout(boolean glo) {
        HttpScope session = this.httpFacade.getScope(Scope.SESSION);
        if (!session.exists()) {
            return;
        }
        OidcSecurityContext securityContext = (OidcSecurityContext)session.getAttachment(OidcSecurityContext.class.getName());
        try {
            if (glo && securityContext != null) {
                OidcClientConfiguration deployment = this.httpFacade.getOidcClientConfiguration();
                session.invalidate();
                if (!deployment.isBearerOnly() && securityContext != null && securityContext instanceof RefreshableOidcSecurityContext) {
                    ((RefreshableOidcSecurityContext)securityContext).logout(deployment);
                }
            } else {
                session.setAttachment(OidcAccount.class.getName(), null);
                session.setAttachment(OidcSecurityContext.class.getName(), null);
            }
        }
        catch (IllegalStateException ise) {
            ElytronMessages.log.debugf("Session %s logged-out already", (Object)session.getID());
        }
    }

    @Override
    public void logoutAll() {
        Collection<String> sessions = this.httpFacade.getScopeIds(Scope.SESSION);
        this.logoutHttpSessions(new ArrayList<String>(sessions));
    }

    @Override
    public void logoutHttpSessions(List<String> ids) {
        for (String id : ids) {
            HttpScope session = this.httpFacade.getScope(Scope.SESSION, id);
            if (session == null) continue;
            session.invalidate();
        }
    }
}

