/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;
import org.wildfly.clustering.singleton.SingletonElectionListener;

public class DefaultSingletonElectionListener
implements SingletonElectionListener {
    private final ServiceName name;
    private final Supplier<Group> group;
    private final AtomicReference<Node> primaryMember = new AtomicReference();

    public DefaultSingletonElectionListener(ServiceName name, Supplier<Group> group) {
        this.name = name;
        this.group = group;
    }

    public void elected(List<Node> candidateMembers, Node electedMember) {
        Node localMember = this.group.get().getLocalMember();
        Node previousElectedMember = this.primaryMember.getAndSet(electedMember);
        if (electedMember != null) {
            ClusteringServerLogger.ROOT_LOGGER.elected(electedMember.getName(), this.name.getCanonicalName());
        } else {
            ClusteringServerLogger.ROOT_LOGGER.noPrimaryElected(this.name.getCanonicalName());
        }
        if (localMember.equals(electedMember)) {
            ClusteringServerLogger.ROOT_LOGGER.startSingleton(this.name.getCanonicalName());
        } else if (localMember.equals(previousElectedMember)) {
            ClusteringServerLogger.ROOT_LOGGER.stopSingleton(this.name.getCanonicalName());
        }
    }
}

