/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.provider;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.context.Flag;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.CompletableFutures;
import org.jboss.as.clustering.context.DefaultExecutorService;
import org.jboss.as.clustering.context.DefaultThreadFactory;
import org.jboss.as.clustering.context.ExecutorServiceFactory;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Invoker;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.infinispan.InfinispanCacheProperties;
import org.wildfly.clustering.ee.infinispan.retry.RetryingInvoker;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.spi.distribution.ConsistentHashLocality;
import org.wildfly.clustering.provider.ServiceProviderRegistration;
import org.wildfly.clustering.provider.ServiceProviderRegistry;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;
import org.wildfly.clustering.server.provider.CacheServiceProviderRegistryConfiguration;
import org.wildfly.clustering.server.provider.ConcurrentAddressSetAddFunction;
import org.wildfly.clustering.server.provider.ConcurrentAddressSetRemoveFunction;
import org.wildfly.clustering.server.provider.CopyOnWriteAddressSetAddFunction;
import org.wildfly.clustering.server.provider.CopyOnWriteAddressSetRemoveFunction;
import org.wildfly.clustering.server.provider.SimpleServiceProviderRegistration;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener
public class CacheServiceProviderRegistry<T>
implements ServiceProviderRegistry<T>,
AutoCloseable {
    private final ExecutorService topologyChangeExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory(this.getClass()));
    private final Batcher<? extends Batch> batcher;
    private final ConcurrentMap<T, Map.Entry<ServiceProviderRegistration.Listener, ExecutorService>> listeners = new ConcurrentHashMap<T, Map.Entry<ServiceProviderRegistration.Listener, ExecutorService>>();
    private final Cache<T, Set<Address>> cache;
    private final org.wildfly.clustering.spi.group.Group<Address> group;
    private final Invoker invoker;
    private final CacheProperties properties;

    public CacheServiceProviderRegistry(CacheServiceProviderRegistryConfiguration<T> config) {
        this.group = config.getGroup();
        this.cache = config.getCache();
        this.batcher = config.getBatcher();
        this.cache.addListener((Object)this);
        this.invoker = new RetryingInvoker(this.cache);
        this.properties = new InfinispanCacheProperties(this.cache.getCacheConfiguration());
    }

    @Override
    public void close() {
        this.cache.removeListener((Object)this);
        this.shutdown(this.topologyChangeExecutor);
        for (Map.Entry entry : this.listeners.values()) {
            ExecutorService executor = (ExecutorService)entry.getValue();
            if (executor == null) continue;
            this.shutdown(executor);
        }
        this.listeners.clear();
    }

    private void shutdown(ExecutorService executor) {
        WildFlySecurityManager.doUnchecked((Object)executor, (ParametricPrivilegedAction)DefaultExecutorService.SHUTDOWN_ACTION);
        try {
            executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public Group getGroup() {
        return this.group;
    }

    public ServiceProviderRegistration<T> register(T service) {
        return this.register(service, null);
    }

    public ServiceProviderRegistration<T> register(T service, ServiceProviderRegistration.Listener listener) {
        AbstractMap.SimpleEntry<ServiceProviderRegistration.Listener, Object> newEntry = new AbstractMap.SimpleEntry<ServiceProviderRegistration.Listener, Object>(listener, null);
        Map.Entry entry = this.listeners.computeIfAbsent(service, key -> {
            if (listener != null) {
                newEntry.setValue(new DefaultExecutorService(listener.getClass(), (Function)ExecutorServiceFactory.SINGLE_THREAD));
            }
            return newEntry;
        });
        if (entry != newEntry) {
            throw new IllegalArgumentException(service.toString());
        }
        this.invoker.invoke((ExceptionRunnable)new RegisterLocalServiceTask(service));
        return new SimpleServiceProviderRegistration<T>(service, this, () -> {
            Address localAddress = (Address)this.group.getAddress(this.group.getLocalMember());
            try (Batch batch = this.batcher.createBatch();){
                this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS, Flag.IGNORE_RETURN_VALUES}).compute(service, (BiFunction)(this.properties.isTransactional() ? new CopyOnWriteAddressSetRemoveFunction(localAddress) : new ConcurrentAddressSetRemoveFunction(localAddress)));
            }
            finally {
                ExecutorService executor;
                Map.Entry oldEntry = (Map.Entry)this.listeners.remove(service);
                if (oldEntry != null && (executor = (ExecutorService)oldEntry.getValue()) != null) {
                    this.shutdown(executor);
                }
            }
        });
    }

    void registerLocal(T service) {
        try (Batch batch = this.batcher.createBatch();){
            this.register((Address)this.group.getAddress(this.group.getLocalMember()), service);
        }
    }

    void register(Address address, T service) {
        this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS, Flag.IGNORE_RETURN_VALUES}).compute(service, (BiFunction)(this.properties.isTransactional() ? new CopyOnWriteAddressSetAddFunction(address) : new ConcurrentAddressSetAddFunction(address)));
    }

    public Set<Node> getProviders(T service) {
        Set addresses = (Set)this.cache.get(service);
        if (addresses == null) {
            return Collections.emptySet();
        }
        TreeSet<Node> members = new TreeSet<Node>();
        for (Address address : addresses) {
            members.add(this.group.createNode((Object)address));
        }
        return Collections.unmodifiableSet(members);
    }

    public Set<T> getServices() {
        return this.cache.keySet();
    }

    @TopologyChanged
    public void topologyChanged(TopologyChangedEvent<T, Set<Address>> event) {
        if (!event.isPre()) {
            ConsistentHash previousHash = event.getWriteConsistentHashAtStart();
            List previousMembers = previousHash.getMembers();
            ConsistentHash hash = event.getWriteConsistentHashAtEnd();
            List members = hash.getMembers();
            if (!members.equals(previousMembers)) {
                Set localServices;
                AdvancedCache cache = event.getCache().getAdvancedCache().withFlags(Flag.FORCE_SYNCHRONOUS);
                Address localAddress = cache.getCacheManager().getAddress();
                final HashSet leftMembers = new HashSet(previousMembers);
                leftMembers.removeAll(members);
                if (!leftMembers.isEmpty()) {
                    ConsistentHashLocality locality = new ConsistentHashLocality((Cache)cache, hash);
                    Iterator addresses = leftMembers.iterator();
                    while (addresses.hasNext()) {
                        if (locality.isLocal(addresses.next())) continue;
                        addresses.remove();
                    }
                }
                Set<Object> set = localServices = !previousMembers.contains(localAddress) ? this.listeners.keySet() : Collections.emptySet();
                if (!leftMembers.isEmpty() || !localServices.isEmpty()) {
                    final Batcher<? extends Batch> batcher = this.batcher;
                    Invoker invoker = this.invoker;
                    try {
                        this.topologyChangeExecutor.submit(new Runnable((Cache)cache, localServices, invoker){
                            final /* synthetic */ Cache val$cache;
                            final /* synthetic */ Set val$localServices;
                            final /* synthetic */ Invoker val$invoker;
                            {
                                this.val$cache = cache;
                                this.val$localServices = set2;
                                this.val$invoker = invoker;
                            }

                            @Override
                            public void run() {
                                if (!leftMembers.isEmpty()) {
                                    try (Batch batch = batcher.createBatch();
                                         CloseableIterator entries = this.val$cache.getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK).entrySet().iterator();){
                                        while (entries.hasNext()) {
                                            Map.Entry entry = (Map.Entry)entries.next();
                                            Set addresses = (Set)entry.getValue();
                                            if (!addresses.removeAll(leftMembers)) continue;
                                            entry.setValue(addresses);
                                        }
                                    }
                                }
                                if (!this.val$localServices.isEmpty()) {
                                    for (Object localService : this.val$localServices) {
                                        this.val$invoker.invoke((ExceptionRunnable)new RegisterLocalServiceTask(localService));
                                    }
                                }
                            }
                        });
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @CacheEntryCreated
    @CacheEntryModified
    public CompletionStage<Void> modified(CacheEntryEvent<T, Set<Address>> event) {
        ServiceProviderRegistration.Listener listener;
        Map.Entry entry;
        if (!event.isPre() && (entry = (Map.Entry)this.listeners.get(event.getKey())) != null && (listener = (ServiceProviderRegistration.Listener)entry.getKey()) != null) {
            ExecutorService executor = (ExecutorService)entry.getValue();
            try {
                executor.submit(() -> {
                    TreeSet<Node> members = new TreeSet<Node>();
                    for (Address address : (Set)event.getValue()) {
                        members.add(this.group.createNode((Object)address));
                    }
                    try {
                        listener.providersChanged(members);
                    }
                    catch (Throwable e) {
                        ClusteringServerLogger.ROOT_LOGGER.serviceProviderRegistrationListenerFailed(e, this.cache.getCacheManager().getCacheManagerConfiguration().cacheManagerName(), this.cache.getName(), members);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
        return CompletableFutures.completedNull();
    }

    private class RegisterLocalServiceTask
    implements ExceptionRunnable<CacheException> {
        private final T localService;

        RegisterLocalServiceTask(T localService) {
            this.localService = localService;
        }

        public void run() {
            CacheServiceProviderRegistry.this.registerLocal(this.localService);
        }
    }
}

