/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jboss.as.core.security.ServerSecurityManager;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInterceptorFactory;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.security.EJBSecurityMetaData;
import org.jboss.as.ejb3.security.SecurityContextInterceptor;
import org.jboss.as.ejb3.security.SecurityContextInterceptorHolder;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;

public class SecurityContextInterceptorFactory
extends ComponentInterceptorFactory {
    private static final String DEFAULT_DOMAIN = "other";
    private final boolean securityRequired;
    private final boolean propagateSecurity;
    private final String policyContextID;

    public SecurityContextInterceptorFactory(boolean securityRequired, String policyContextID) {
        this(securityRequired, true, policyContextID);
    }

    public SecurityContextInterceptorFactory(boolean securityRequired, boolean propagateSecurity, String policyContextID) {
        this.securityRequired = securityRequired;
        this.propagateSecurity = propagateSecurity;
        this.policyContextID = policyContextID;
    }

    protected Interceptor create(Component component, InterceptorFactoryContext context) {
        if (!(component instanceof EJBComponent)) {
            throw EjbLogger.ROOT_LOGGER.unexpectedComponent(component, EJBComponent.class);
        }
        EJBComponent ejbComponent = (EJBComponent)component;
        ServerSecurityManager securityManager = this.propagateSecurity ? ejbComponent.getSecurityManager() : (ServerSecurityManager)((Supplier)ejbComponent.getSecurityManager()).get();
        EJBSecurityMetaData securityMetaData = ejbComponent.getSecurityMetaData();
        String securityDomainName = securityMetaData.getSecurityDomainName();
        if (securityDomainName == null) {
            securityDomainName = DEFAULT_DOMAIN;
        }
        if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
            EjbLogger.ROOT_LOGGER.trace("Using security domain: " + securityDomainName + " for Jakarta Enterprise Beans " + ejbComponent.getComponentName());
        }
        String runAs = securityMetaData.getRunAs();
        String runAsPrincipal = securityMetaData.getRunAsPrincipal();
        SecurityRolesMetaData securityRoles = securityMetaData.getSecurityRoles();
        Set extraRoles = null;
        Map principalVsRolesMap = null;
        if (securityRoles != null) {
            principalVsRolesMap = securityRoles.getPrincipalVersusRolesMap();
            if (runAsPrincipal != null) {
                extraRoles = securityRoles.getSecurityRoleNamesByPrincipal(runAsPrincipal);
            }
        }
        SecurityContextInterceptorHolder holder = new SecurityContextInterceptorHolder();
        holder.setSecurityManager(securityManager).setSecurityDomain(securityDomainName).setRunAs(runAs).setRunAsPrincipal(runAsPrincipal).setPolicyContextID(this.policyContextID).setExtraRoles(extraRoles).setPrincipalVsRolesMap(principalVsRolesMap).setSkipAuthentication(!this.securityRequired);
        return new SecurityContextInterceptor(holder);
    }
}

