/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public enum Protocol {
    REMOTE("remote"),
    REMOTE_HTTP("remote+http"),
    HTTP_REMOTING("http-remoting"),
    HTTPS_REMOTING("https-remoting"),
    REMOTE_HTTPS("remote+https");

    private static final Map<String, Protocol> MAP;
    private final String localName;

    public static Protocol forName(String localName) {
        Protocol value = localName != null ? MAP.get(localName.toLowerCase(Locale.ENGLISH)) : null;
        return value == null && localName != null ? Protocol.valueOf(localName.toUpperCase(Locale.ENGLISH)) : value;
    }

    private Protocol(String localName) {
        this.localName = localName;
    }

    public String toString() {
        return this.localName;
    }

    public ModelNode toModelNode() {
        return new ModelNode().set(this.toString());
    }

    static {
        HashMap<String, Protocol> map = new HashMap<String, Protocol>();
        for (Protocol value : Protocol.values()) {
            map.put(value.localName, value);
        }
        MAP = map;
    }
}

