/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.loop;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.loop.ForControlFlow;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.ParsedCommandLine;

public class ForHandler
extends CommandHandlerWithHelp {
    private final ArgumentWithValue varName = new ArgumentWithValue((CommandHandlerWithArguments)this, 0, "--var");
    private final ArgumentWithValue in;

    public ForHandler() {
        super("for", true);
        this.varName.addCantAppearAfter(this.helpArg);
        this.in = new ArgumentWithValue((CommandHandlerWithArguments)this, (CommandLineCompleter)new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public Collection<String> getAllCandidates(CommandContext ctx) {
                return Collections.singletonList("in");
            }
        }), 1, "--in");
        this.in.addRequiredPreceding(this.varName);
        ArgumentWithValue line = new ArgumentWithValue(this, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                char ch;
                String varNameStr;
                ParsedCommandLine args = ctx.getParsedCommandLine();
                String lnStr = ForHandler.this.in.getValue(args);
                if (lnStr == null) {
                    return -1;
                }
                String originalLine = args.getOriginalLine();
                try {
                    varNameStr = ForHandler.this.varName.getValue(args, true);
                }
                catch (CommandFormatException e) {
                    return -1;
                }
                int i = originalLine.indexOf(varNameStr);
                if (i < 0) {
                    return -1;
                }
                if ((i = originalLine.indexOf("in ", i + varNameStr.length())) < 0) {
                    return -1;
                }
                String cmd = originalLine.substring(i + 3);
                int cmdResult = ctx.getDefaultCommandCompleter().complete(ctx, cmd, cmd.length(), candidates);
                if (cmdResult < 0) {
                    return cmdResult;
                }
                int escapeCorrection = 0;
                int start = originalLine.length() - 1 - buffer.length();
                while (start - escapeCorrection >= 0 && !Character.isWhitespace(ch = originalLine.charAt(start - escapeCorrection)) && ch != '=') {
                    ++escapeCorrection;
                }
                return buffer.length() + escapeCorrection - (cmd.length() - cmdResult);
            }
        }, Integer.MAX_VALUE, "--line"){};
        line.addRequiredPreceding(this.in);
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        return ForControlFlow.get(ctx) == null && !ctx.getBatchManager().isBatchActive();
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        if (ForControlFlow.get(ctx) != null) {
            throw new CommandFormatException("for is not allowed while in for block");
        }
        BatchManager batchManager = ctx.getBatchManager();
        if (batchManager.isBatchActive()) {
            throw new CommandFormatException("for is not allowed while in batch mode.");
        }
        String argsStr = ctx.getArgumentsString();
        if (argsStr == null) {
            throw new CommandFormatException("The command is missing arguments.");
        }
        ParsedCommandLine args = ctx.getParsedCommandLine();
        String varName = this.varName.getOriginalValue(args, true);
        int i = argsStr.indexOf(varName);
        if (i < 0) {
            throw new CommandFormatException("Failed to locate '" + varName + "' in '" + argsStr + "'");
        }
        if ((i = argsStr.indexOf("in", i + varName.length())) < 0) {
            throw new CommandFormatException("Failed to locate 'in' in '" + argsStr + "'");
        }
        String requestStr = argsStr.substring(i + 2);
        ctx.registerRedirection(new ForControlFlow(ctx, varName, requestStr));
    }

    @Override
    public boolean hasArgument(CommandContext ctx, int index) {
        return true;
    }

    @Override
    public boolean hasArgument(CommandContext ctx, String name) {
        return true;
    }
}

