/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xnio.Bits;

public final class StreamUtils {
    public static int readInt8(InputStream is) throws IOException {
        int res = is.read();
        if (res == -1) {
            throw new EOFException();
        }
        return res;
    }

    public static int readInt16LE(InputStream is) throws IOException {
        int a = is.read();
        if (a == -1) {
            throw new EOFException();
        }
        int b = is.read();
        if (b == -1) {
            throw new EOFException();
        }
        return a | b << 8;
    }

    public static int readInt16BE(InputStream is) throws IOException {
        int a = is.read();
        if (a == -1) {
            throw new EOFException();
        }
        int b = is.read();
        if (b == -1) {
            throw new EOFException();
        }
        return b | a << 8;
    }

    public static int readInt24LE(InputStream is) throws IOException {
        int a = is.read();
        if (a == -1) {
            throw new EOFException();
        }
        int b = is.read();
        if (b == -1) {
            throw new EOFException();
        }
        int c = is.read();
        if (c == -1) {
            throw new EOFException();
        }
        return a | b << 8 | c << 16;
    }

    public static int readInt24BE(InputStream is) throws IOException {
        int a = is.read();
        if (a == -1) {
            throw new EOFException();
        }
        int b = is.read();
        if (b == -1) {
            throw new EOFException();
        }
        int c = is.read();
        if (c == -1) {
            throw new EOFException();
        }
        return c | b << 8 | a << 16;
    }

    public static int readInt32LE(InputStream is) throws IOException {
        int a = is.read();
        if (a == -1) {
            throw new EOFException();
        }
        int b = is.read();
        if (b == -1) {
            throw new EOFException();
        }
        int c = is.read();
        if (c == -1) {
            throw new EOFException();
        }
        int d = is.read();
        if (d == -1) {
            throw new EOFException();
        }
        return a | b << 8 | c << 16 | d << 24;
    }

    public static int readInt32BE(InputStream is) throws IOException {
        int a = is.read();
        if (a == -1) {
            throw new EOFException();
        }
        int b = is.read();
        if (b == -1) {
            throw new EOFException();
        }
        int c = is.read();
        if (c == -1) {
            throw new EOFException();
        }
        int d = is.read();
        if (d == -1) {
            throw new EOFException();
        }
        return d | c << 8 | b << 16 | a << 24;
    }

    public static void skipBytes(InputStream is, long skip) throws IOException {
        while (skip > 0L) {
            long res = is.skip(skip);
            skip -= res;
            if (res != 0L) continue;
            StreamUtils.readInt8(is);
            --skip;
        }
    }

    public static int readPackedUnsignedInt31(InputStream is) throws IOException {
        int res = StreamUtils.readInt8(is);
        int t = res & 0x7F;
        while (Bits.allAreSet((int)res, (int)128)) {
            res = StreamUtils.readInt8(is);
            t = t << 7 | res & 0x7F;
        }
        return t & Integer.MAX_VALUE;
    }

    public static int readPackedUnsignedInt32(InputStream is) throws IOException {
        int res = StreamUtils.readInt8(is);
        int t = res & 0x7F;
        while (Bits.allAreSet((int)res, (int)128)) {
            res = StreamUtils.readInt8(is);
            t = t << 7 | res & 0x7F;
        }
        return t;
    }

    public static int readPackedSignedInt32(InputStream is) throws IOException {
        int res = StreamUtils.readInt8(is);
        int t = res & 0x7F;
        if (Bits.allAreSet((int)t, (int)64)) {
            t |= 0xFFC0;
        }
        if (Bits.allAreSet((int)res, (int)128)) {
            do {
                res = StreamUtils.readInt8(is);
                t = t << 7 | res & 0x7F;
            } while (Bits.allAreSet((int)res, (int)128));
        }
        return t;
    }

    public static void writeInt8(OutputStream os, int val) throws IOException {
        os.write(val);
    }

    public static void writeInt8(OutputStream os, long val) throws IOException {
        StreamUtils.writeInt8(os, (int)val);
    }

    public static void writeInt16LE(OutputStream os, int val) throws IOException {
        os.write(val);
        os.write(val >> 8);
    }

    public static void writeInt16LE(OutputStream os, long val) throws IOException {
        StreamUtils.writeInt16LE(os, (int)val);
    }

    public static void writeInt16BE(OutputStream os, int val) throws IOException {
        os.write(val >> 8);
        os.write(val);
    }

    public static void writeInt16BE(OutputStream os, long val) throws IOException {
        StreamUtils.writeInt16BE(os, (int)val);
    }

    public static void writeInt24LE(OutputStream os, int val) throws IOException {
        os.write(val);
        os.write(val >> 8);
        os.write(val >> 16);
    }

    public static void writeInt24LE(OutputStream os, long val) throws IOException {
        StreamUtils.writeInt24LE(os, (int)val);
    }

    public static void writeInt24BE(OutputStream os, int val) throws IOException {
        os.write(val >> 16);
        os.write(val >> 8);
        os.write(val);
    }

    public static void writeInt24BE(OutputStream os, long val) throws IOException {
        StreamUtils.writeInt24BE(os, (int)val);
    }

    public static void writeInt32LE(OutputStream os, int val) throws IOException {
        os.write(val);
        os.write(val >> 8);
        os.write(val >> 16);
        os.write(val >> 24);
    }

    public static void writeInt32LE(OutputStream os, long val) throws IOException {
        StreamUtils.writeInt32LE(os, (int)val);
    }

    public static void writeInt32BE(OutputStream os, int val) throws IOException {
        os.write(val >> 24);
        os.write(val >> 16);
        os.write(val >> 8);
        os.write(val);
    }

    public static void writeInt32BE(OutputStream os, long val) throws IOException {
        StreamUtils.writeInt32BE(os, (int)val);
    }

    public static void writePackedUnsignedInt31(OutputStream os, int val) throws IOException {
        val &= Integer.MAX_VALUE;
        while (32 - Integer.numberOfLeadingZeros(val) > 7) {
            os.write(val | 0x80);
            val >>>= 7;
        }
        assert (Bits.allAreClear((int)val, (int)128));
        os.write(val);
    }

    public static void writePackedUnsignedInt32(OutputStream os, int val) throws IOException {
        while (32 - Integer.numberOfLeadingZeros(val) > 7) {
            os.write(val | 0x80);
            val >>>= 7;
        }
        assert (Bits.allAreClear((int)val, (int)128));
        os.write(val);
    }

    public static void readFully(InputStream is, byte[] bytes) throws IOException {
        StreamUtils.readFully(is, bytes, 0, bytes.length);
    }

    public static void readFully(InputStream is, byte[] bytes, int off, int len) throws IOException {
        int t = is.read(bytes, off, len);
        if (t == -1) {
            throw new EOFException();
        }
        while (t < len) {
            int res = is.read(bytes, off + t, len - t);
            if (res == -1) {
                throw new EOFException();
            }
            t += res;
        }
    }
}

