/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.validator;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.jca.core.connectionmanager.pool.validator.SecurityActions;
import org.jboss.logging.Logger;

public class ConnectionValidator {
    private static CoreLogger logger = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)ConnectionValidator.class.getName());
    private static final String THREAD_NAME = "ConnectionValidator";
    private static ConnectionValidator instance = new ConnectionValidator();
    private CopyOnWriteArrayList<ManagedConnectionPool> registeredPools = new CopyOnWriteArrayList();
    private ExecutorService executorService = null;
    private boolean isExternal = false;
    private long interval = Long.MAX_VALUE;
    private long next = Long.MAX_VALUE;
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private Lock lock = new ReentrantLock(true);
    private Condition condition = this.lock.newCondition();

    private ConnectionValidator() {
    }

    public static ConnectionValidator getInstance() {
        return instance;
    }

    public void setExecutorService(ExecutorService v) {
        if (v != null) {
            this.executorService = v;
            this.isExternal = true;
        } else {
            this.executorService = null;
            this.isExternal = false;
        }
    }

    public void start() throws Throwable {
        if (!this.isExternal) {
            this.executorService = Executors.newSingleThreadExecutor(new ValidatorThreadFactory());
        }
        this.shutdown.set(false);
        this.interval = Long.MAX_VALUE;
        this.next = Long.MAX_VALUE;
        this.executorService.execute(new ConnectionValidatorRunner());
    }

    public void stop() throws Throwable {
        ConnectionValidator.instance.shutdown.set(true);
        if (!this.isExternal) {
            ConnectionValidator.instance.executorService.shutdownNow();
            ConnectionValidator.instance.executorService = null;
        }
        ConnectionValidator.instance.registeredPools.clear();
    }

    public void registerPool(ManagedConnectionPool mcp, long interval) {
        logger.debugf("Register pool: %s (interval=%s)", mcp, interval);
        instance.internalRegisterPool(mcp, interval);
    }

    public void unregisterPool(ManagedConnectionPool mcp) {
        logger.debugf("Unregister pool: %s", mcp);
        instance.internalUnregisterPool(mcp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRegisterPool(ManagedConnectionPool mcp, long interval) {
        try {
            this.lock.lock();
            this.registeredPools.addIfAbsent(mcp);
            if (interval > 1L && interval / 2L < this.interval) {
                this.interval = interval / 2L;
                long maybeNext = System.currentTimeMillis() + this.interval;
                if (this.next > maybeNext && maybeNext > 0L) {
                    this.next = maybeNext;
                    if (logger.isDebugEnabled()) {
                        logger.debug("About to notify thread: old next: " + this.next + ", new next: " + maybeNext);
                    }
                    this.condition.signal();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void internalUnregisterPool(ManagedConnectionPool mcp) {
        this.registeredPools.remove(mcp);
        if (this.registeredPools.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Setting interval to Long.MAX_VALUE");
            }
            this.interval = Long.MAX_VALUE;
        }
    }

    private class ConnectionValidatorRunner
    implements Runnable {
        private ConnectionValidatorRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClassLoader oldTccl = SecurityActions.getThreadContextClassLoader();
            SecurityActions.setThreadContextClassLoader(ConnectionValidator.class.getClassLoader());
            try {
                while (!ConnectionValidator.this.shutdown.get()) {
                    try {
                        ConnectionValidator.this.lock.lock();
                        boolean result = instance.condition.await(instance.interval, TimeUnit.MILLISECONDS);
                        if (logger.isTraceEnabled()) {
                            logger.trace("Result of await: " + result);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("Notifying pools, interval: " + ConnectionValidator.this.interval);
                        }
                    }
                    finally {
                        ConnectionValidator.this.lock.unlock();
                    }
                    for (ManagedConnectionPool mcp : ConnectionValidator.this.registeredPools) {
                        mcp.validateConnections();
                    }
                    try {
                        ConnectionValidator.this.lock.lock();
                        ConnectionValidator.this.next = System.currentTimeMillis() + ConnectionValidator.this.interval;
                        if (ConnectionValidator.this.next >= 0L) continue;
                        ConnectionValidator.this.next = Long.MAX_VALUE;
                    }
                    finally {
                        ConnectionValidator.this.lock.unlock();
                    }
                }
            }
            catch (InterruptedException e) {
                if (!ConnectionValidator.this.shutdown.get()) {
                    logger.returningConnectionValidatorInterrupted();
                }
            }
            catch (RuntimeException e) {
                logger.connectionValidatorIgnoredUnexpectedRuntimeException(e);
            }
            catch (Exception e) {
                logger.connectionValidatorIgnoredUnexpectedError(e);
            }
            finally {
                SecurityActions.setThreadContextClassLoader(oldTccl);
            }
        }
    }

    private static class ValidatorThreadFactory
    implements ThreadFactory {
        private ValidatorThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, ConnectionValidator.THREAD_NAME);
            thread.setDaemon(true);
            return thread;
        }
    }
}

